/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.user.utils;

import com.adobe.cq.ups.integration.service.PlatformService;
import com.adobe.cq.ups.integration.service.PlatformServiceException;
import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.json.JSONException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"resource.paths=glob:/home/users", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.property.names.hint=rep:authorizableId"})
public class UserCreationListener
implements ResourceChangeListener {
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    PlatformService platformService;
    @Reference
    private transient UpsTokenProviderProxy tokenProviderProxy;
    private static final Logger log = LoggerFactory.getLogger(UserCreationListener.class);
    private String SCHEMA_REF_ID = "https://ns.adobe.com/aemengineeringprod/schemas/e2368d7585a777ba68b73eef7f1220d4";
    private String DATASET_ID = "5d81fe2c77561c16359f90af";
    private String inletUrlCache = null;
    private String TOGGLE_DISABLED_MESSAGE = "UPS Feature is disabled.";
    private String IMS_MISSING_MESSAGE = "Adobe Experience Platform IMS configuration missing";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ToggleRouter toggleRouter;

    public void onChange(List<ResourceChange> changes) {
        if (!this.toggleRouter.isEnabled("CQ-4280691_aem_unified_profile_integration")) {
            log.info(this.TOGGLE_DISABLED_MESSAGE);
            return;
        }
        try {
            String accessPayloadData = this.tokenProviderProxy.getAccessPayloadData("Adobe Experience Platform");
            if (StringUtils.isEmpty((CharSequence)accessPayloadData)) {
                log.info(this.IMS_MISSING_MESSAGE);
                return;
            }
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            serviceMap.put("sling.service.subservice", "Adobe Experience Platform");
            for (ResourceChange change : changes) {
                ResourceResolver resourceResolver = this.resolverFactory.getServiceResourceResolver(serviceMap);
                UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
                User user = userManager != null ? (User)userManager.getAuthorizableByPath(change.getPath()) : null;
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (user == null) continue;
                JsonNode accessPayload = new ObjectMapper().readTree(accessPayloadData);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-api-key", accessPayload.findPath("apikey").asText());
                String imsOrgId = accessPayload.findPath("org").asText();
                headers.put("x-gw-ims-org-id", imsOrgId);
                headers.put("Authorization", "Bearer " + accessPayload.findPath("token").asText());
                HashMap<String, String> params = new HashMap<String, String>();
                if (this.inletUrlCache == null) {
                    JsonNode responsJson = this.platformService.createInlet(headers, params);
                    this.inletUrlCache = responsJson.get("inletUrl").asText();
                }
                Node node = session.getNode(user.getPath());
                HashMap<String, String> payloadMap = new HashMap<String, String>();
                payloadMap.put("firstName", user.getProperty("profile/givenName")[0].getString());
                payloadMap.put("lastName", user.getProperty("profile/familyName")[0].getString());
                payloadMap.put("email", user.getProperty("profile/email")[0].getString());
                payloadMap.put("id", node.getIdentifier());
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonPayload = mapper.valueToTree(payloadMap);
                headers = new HashMap();
                headers.put("Authorization", "Bearer " + accessPayload.findPath("token").asText());
                params = new HashMap();
                params.put("schemaRefId", this.SCHEMA_REF_ID);
                params.put("datasetId", this.DATASET_ID);
                params.put("inletUrl", this.inletUrlCache);
                params.put("imsOrgId", imsOrgId);
                this.platformService.streamIngestUser(headers, jsonPayload, params);
            }
        }
        catch (PlatformServiceException | CryptoException | IOException | RepositoryException | LoginException | JSONException e) {
            log.error(e.getMessage());
        }
    }
}

