/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.integration.service.impl;

import com.adobe.cq.ups.integration.service.UpsTokenProviderProxy;
import com.adobe.granite.auth.oauth.AccessTokenProvider;
import com.adobe.granite.crypto.CryptoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class UpsTokenProviderProxyImpl
implements UpsTokenProviderProxy {
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Map<Map<String, String>, AccessTokenProvider> availableTokenProviders = new ConcurrentHashMap<Map<String, String>, AccessTokenProvider>();
    private static final String ACCESS_TOKEN_PROVIDER_FACTORY_PID = "com.adobe.granite.auth.oauth.accesstoken.provider";
    private static final String ACCESS_TOKEN_PROVIDER_NAME = "name";
    private static final String ACCESS_TOKEN_PROVIDER_TITLE = "auth.token.provider.title";
    private static final String ACCESS_TOKEN_PROVIDER_DEFAULT_CLAIMS_ORG_ID = "auth.token.provider.default.claims";
    private static final String ACCESS_TOKEN_PROVIDER_CLIENT_ID = "auth.token.provider.client.id";
    private static final Logger LOG = LoggerFactory.getLogger(UpsTokenProviderProxy.class);

    private String getOrgId(String name) {
        String orgId = null;
        for (Map<String, String> infoMap : this.availableTokenProviders.keySet()) {
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            orgId = PropertiesUtil.toString((Object)infoMap.get("orgId"), (String)"");
            break;
        }
        return orgId;
    }

    private String getClientId(String name) {
        String clientId = null;
        for (Map<String, String> infoMap : this.availableTokenProviders.keySet()) {
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            clientId = PropertiesUtil.toString((Object)infoMap.get("clientId"), (String)"");
            break;
        }
        return clientId;
    }

    private AccessTokenProvider getAccessTokenProvider(String name) {
        AccessTokenProvider accessTokenProvider = null;
        for (Map.Entry<Map<String, String>, AccessTokenProvider> entry : this.availableTokenProviders.entrySet()) {
            Map<String, String> infoMap = entry.getKey();
            if (!infoMap.get(ACCESS_TOKEN_PROVIDER_NAME).equals(name)) continue;
            accessTokenProvider = entry.getValue();
            break;
        }
        return accessTokenProvider;
    }

    private Map<String, String> getTokenProviderInfo(Map<?, ?> props) {
        String name = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_NAME), (String)"");
        String title = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_TITLE), (String)"");
        String clientId = PropertiesUtil.toString(props.get(ACCESS_TOKEN_PROVIDER_CLIENT_ID), (String)"");
        String org = "";
        String[] jwtPayload = PropertiesUtil.toStringArray(props.get(ACCESS_TOKEN_PROVIDER_DEFAULT_CLAIMS_ORG_ID));
        for (int i = 0; i < jwtPayload.length; ++i) {
            String data = jwtPayload[i];
            String key = data.split(":")[0];
            if (!key.trim().equalsIgnoreCase("\"iss\"")) continue;
            org = data.split(":")[1].replace('\"', ' ').trim();
            break;
        }
        HashMap<String, String> tokenProviderInfo = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)title)) {
            tokenProviderInfo.put(ACCESS_TOKEN_PROVIDER_NAME, name);
            tokenProviderInfo.put("title", title);
            tokenProviderInfo.put("orgId", org);
            tokenProviderInfo.put("clientId", clientId);
        }
        return tokenProviderInfo;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, target="(&(service.factoryPid=com.adobe.granite.auth.oauth.accesstoken.provider)(name=Adobe Experience Platform*))")
    void bindAccessTokenProvider(AccessTokenProvider accessTokenProvider, Map<?, ?> props) {
        this.availableTokenProviders.put(this.getTokenProviderInfo(props), accessTokenProvider);
    }

    void unbindAccessTokenProvider(Map<?, ?> props) {
        this.availableTokenProviders.remove(this.getTokenProviderInfo(props));
    }

    @Override
    @Nullable
    public String getAccessPayloadData(@Nonnull String name) throws CryptoException, IOException, LoginException, JSONException {
        ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "Adobe Experience Platform"));
        AccessTokenProvider accessTokenProvider = this.getAccessTokenProvider(name);
        String token = accessTokenProvider != null ? accessTokenProvider.getAccessToken(resourceResolver, resourceResolver.getUserID(), null) : null;
        String org = this.getOrgId(name);
        String apiKey = this.getClientId(name);
        JSONObject oAuthClaimData = new JSONObject();
        try {
            oAuthClaimData.put("org", (Object)org);
            oAuthClaimData.put("token", (Object)token);
            oAuthClaimData.put("apikey", (Object)apiKey);
        }
        catch (JSONException e) {
            String msg = String.format("Unable to set auth claim data object : %s", e.getMessage());
            LOG.error(msg);
            throw new IOException(msg, e);
        }
        return oAuthClaimData.toString();
    }

    @Override
    @Nonnull
    public Set<Map<String, String>> getTokenProvidersInfo() {
        return this.availableTokenProviders.keySet();
    }
}

