/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.ups.integration.service.impl;

import com.adobe.cq.ups.integration.service.PlatformService;
import com.adobe.cq.ups.integration.service.PlatformServiceException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public final class PlatformServiceImpl
implements PlatformService {
    static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private String endpointUri;
    private int connectionTimeout = 60000;
    private int socketTimeout = 30000;
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public JsonNode getUnionList(Map<String, String> headers, Map<String, String> parameters) throws PlatformServiceException {
        this.checkHeaders(headers);
        URI uri = this.buildURI(this.endpointUri + "/data/foundation/schemaregistry/tenant" + "/unions", parameters);
        headers.put("Accept", "application/vnd.adobe.xed-full+json");
        return this.request((HttpRequestBase)new HttpGet(uri), headers);
    }

    @Override
    public JsonNode getVariables(String className, String classVersion, Map<String, String> headers) throws PlatformServiceException {
        this.checkHeaders(headers);
        URI uri = this.buildURI(this.endpointUri + "/data/foundation/schemaregistry/tenant" + "/unions" + String.format("/%s", className + "__union"), null);
        String version = StringUtils.isBlank((CharSequence)classVersion) ? "1" : classVersion.substring(0, classVersion.indexOf(46));
        headers.put("Accept", "application/vnd.adobe.xed-full+json;version=" + version);
        return this.request((HttpRequestBase)new HttpGet(uri), headers);
    }

    @Override
    public JsonNode createInlet(Map<String, String> headers, Map<String, String> parameters) throws PlatformServiceException {
        this.checkHeaders(headers);
        URI uri = this.buildURI(this.endpointUri + "/data/core/edge/inlet", parameters);
        headers.put("Cache-Control", "no-cache");
        headers.put("Content-Type", "application/json");
        JsonObject jsonBuilder = Json.createObjectBuilder().add("name", "AEM Data Inlet").add("description", "Collects streaming data from AEM").add("sourceId", "aem-" + System.currentTimeMillis()).add("dataType", "xdm").add("authenticationRequired", "true").build();
        StringEntity requestData = new StringEntity(jsonBuilder.toString(), ContentType.APPLICATION_JSON);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setEntity((HttpEntity)requestData);
        return this.request((HttpRequestBase)postRequest, headers);
    }

    @Override
    public JsonNode streamIngestUser(Map<String, String> headers, JsonNode userData, Map<String, String> parameters) throws PlatformServiceException {
        String schemaVersion = parameters.get("schemaVersion") != null ? parameters.get("schemaVersion") : "1";
        headers.put("Content-Type", "application/json");
        URI uri = this.buildURI(parameters.get("inletUrl"), null);
        JsonObject jsonBuilder = Json.createObjectBuilder().add("header", (JsonValue)Json.createObjectBuilder().add("schemaRef", (JsonValue)Json.createObjectBuilder().add("id", parameters.get("schemaRefId")).add("contentType", "application/vnd.adobe.xed-full+json;version=" + schemaVersion).build()).add("imsOrgId", parameters.get("imsOrgId")).add("source", (JsonValue)Json.createObjectBuilder().add("name", "AEM").build()).add("datasetId", parameters.get("datasetId")).build()).add("body", (JsonValue)Json.createObjectBuilder().add("xdmMeta", (JsonValue)Json.createObjectBuilder().add("schemaRef", (JsonValue)Json.createObjectBuilder().add("id", parameters.get("schemaRefId")).add("contentType", "application/vnd.adobe.xed-full+json;version=" + schemaVersion).build()).build()).add("xdmEntity", (JsonValue)Json.createObjectBuilder().add("_id", userData.get("id").asText()).add("identityMap", (JsonValue)Json.createObjectBuilder().add("userid", (JsonValue)Json.createArrayBuilder().add((JsonValue)Json.createObjectBuilder().add("id", userData.get("id").asText()).build()).build()).build()).add("person", (JsonValue)Json.createObjectBuilder().add("name", (JsonValue)Json.createObjectBuilder().add("firstName", userData.get("firstName").asText()).add("lastName", userData.get("lastName").asText()).build()).build()).add("personalEmail", (JsonValue)Json.createObjectBuilder().add("primary", true).add("address", userData.get("email").asText()).add("type", "personal").add("status", "active").build()).build()).build()).build();
        StringEntity requestData = new StringEntity(jsonBuilder.toString(), ContentType.APPLICATION_JSON);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setEntity((HttpEntity)requestData);
        return this.request((HttpRequestBase)postRequest, headers);
    }

    @Activate
    void activate(Configuration configuration) {
        this.endpointUri = configuration.endpointUri();
        this.connectionTimeout = configuration.connectionTimeout();
        if (this.connectionTimeout < 0) {
            throw new IllegalArgumentException("Connection timeout value cannot be less than 0");
        }
        this.socketTimeout = configuration.socketTimeout();
        if (this.socketTimeout < 0) {
            throw new IllegalArgumentException("Socket timeout value cannot be less than 0");
        }
    }

    private URI buildURI(@Nonnull String uriStr, @Nullable Map<String, String> parameters) throws PlatformServiceException {
        try {
            URI uri = new URI(uriStr);
            URIBuilder uriBuilder = new URIBuilder(uri);
            if (parameters != null) {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    uriBuilder.addParameter(parameter.getKey(), parameter.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new PlatformServiceException("Unable to build URI", e);
        }
    }

    private JsonNode request(HttpRequestBase request, Map<String, String> headers) throws PlatformServiceException {
        JsonNode jsonResponse = null;
        CloseableHttpClient httpClient = null;
        HttpUriRequest apiRequest = null;
        CloseableHttpResponse apiResponse = null;
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build();
            httpClient = this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(config).build();
            apiRequest = this.buildAPIRequest(request, headers);
            this.logRequest(apiRequest, "UPS API Request");
            apiResponse = httpClient.execute(apiRequest);
            jsonResponse = this.getJsonResponse(apiRequest, apiResponse);
        }
        catch (IOException | ParseException e) {
            try {
                throw new PlatformServiceException("API request failed", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(apiResponse);
                IOUtils.closeQuietly(httpClient);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)apiResponse);
        IOUtils.closeQuietly((Closeable)httpClient);
        return jsonResponse;
    }

    private void checkHeaders(Map<String, String> headers) {
        this.checkHeaders(headers, "x-api-key");
        this.checkHeaders(headers, "Authorization");
        this.checkHeaders(headers, "x-gw-ims-org-id");
    }

    private void checkHeaders(Map<String, String> headers, String headerKey) {
        if (null == headers || StringUtils.isBlank((CharSequence)headers.get(headerKey))) {
            throw new IllegalArgumentException(String.format("Header %s cannot be empty", headerKey));
        }
    }

    private HttpUriRequest buildAPIRequest(HttpRequestBase request, Map<String, String> headers) {
        HttpRequestBase apiRequest = null;
        apiRequest = request;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            apiRequest.addHeader(header.getKey(), header.getValue());
        }
        return apiRequest;
    }

    private JsonNode getJsonResponse(HttpUriRequest apiRequest, CloseableHttpResponse apiResponse) throws PlatformServiceException {
        block5: {
            StatusLine responseStatusLine = apiResponse != null ? apiResponse.getStatusLine() : null;
            int responseStatusCode = responseStatusLine != null ? responseStatusLine.getStatusCode() : -1;
            try {
                HttpEntity entity;
                HttpEntity httpEntity = entity = apiResponse != null ? apiResponse.getEntity() : null;
                if (responseStatusCode == 200 || responseStatusCode == 201) {
                    if (entity != null) {
                        return new ObjectMapper().readTree(EntityUtils.toString((HttpEntity)entity));
                    }
                    break block5;
                }
                if (entity != null && this.log.isDebugEnabled()) {
                    this.log.debug("Unexpected response status code [{}] for request [{}].\n{}", new Object[]{responseStatusCode, apiRequest.getURI(), EntityUtils.toString((HttpEntity)entity)});
                }
                throw new PlatformServiceException("Unexpected response status code " + responseStatusCode);
            }
            catch (IOException | ParseException e) {
                throw new PlatformServiceException("API request failed", e);
            }
        }
        return null;
    }

    private void logRequest(HttpUriRequest request, String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: {} {}", new Object[]{message, request.getMethod(), request.getURI()});
        }
    }

    @ObjectClassDefinition(name="Adobe AEM UPS HTTP Client", description="HTTP Client used to communicate with Adobe Experience Platform (UPS) APIs")
    public static @interface Configuration {
        @AttributeDefinition(name="API endpoint URI", description="The Adobe UPS API endpoint URI. Default is https://platform.adobe.io")
        public String endpointUri() default "https://platform.adobe.io";

        @AttributeDefinition(name="Connection timeout", description="Timeout in milliseconds until a connection is established. A timeout value of zero is interpreted as an infinite timeout. Default is 60000ms")
        public int connectionTimeout() default 60000;

        @AttributeDefinition(name="Socket timeout", description="Timeout in milliseconds for waiting for data or a maximum period of inactivity between two consecutive data packets. Default is 30000ms")
        public int socketTimeout() default 30000;
    }
}

