/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.ui;

import com.adobe.cq.unifiedshell.UnifiedShellContext;
import com.adobe.cq.unifiedshell.impl.config.RepositoryIdentifier;
import com.adobe.cq.unifiedshell.impl.config.UnifiedShellConfService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.featureflags.Features;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={UnifiedShellContext.class})
public class UnifiedShellContextImpl
implements UnifiedShellContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedShellContextImpl.class);
    private static final String REP_EXTERNAL_ID = "rep:externalId";
    @Self
    SlingHttpServletRequest request;
    @OSGiService
    Features features;
    @OSGiService
    UnifiedShellConfService confService;
    @OSGiService
    RepositoryIdentifier repositoryIdentifier;
    private InternalContext context;

    @PostConstruct
    protected void init() {
        InternalContext context = new InternalContext();
        HashMap<String, Object> metricsConfig = new HashMap<String, Object>();
        metricsConfig.put("spaAppId", "aem-touchui");
        metricsConfig.put("spaVersion", this.confService.getProductVersion());
        context.setMetricsConfig(metricsConfig);
        context.setUnifiedShellEnabled(this.features.isEnabled("com.adobe.cq.unifiedshell.feature.flag"));
        context.setUserImpersonated(this.request.getResourceResolver().getAttribute("user.impersonation") != null);
        context.setCustomEnvLabel(this.confService.getConf().getCustomEnvLabel());
        context.setRepositoryId(this.repositoryIdentifier.getRepositoryId());
        context.setExcludePatterns(this.confService.getExcludePatterns());
        User user = (User)this.request.getResourceResolver().adaptTo(User.class);
        try {
            if (user != null && user.hasProperty(REP_EXTERNAL_ID) && user.getProperty(REP_EXTERNAL_ID).length >= 1) {
                context.setUserSupported(user.getProperty(REP_EXTERNAL_ID)[0].getString().endsWith(";ims"));
            }
        }
        catch (RepositoryException e) {
            LOGGER.error("[init] failed to read properties for user " + this.request.getResourceResolver().getUserID(), (Throwable)e);
        }
        this.context = context;
    }

    @Override
    @NotNull
    public String toJson() {
        if (this.context != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writeValueAsString((Object)this.context);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("failed to serialize internal context", (Throwable)e);
            }
        }
        return "{}";
    }

    @JsonSerialize
    public static class InternalContext {
        @JsonProperty(value="isEnabled")
        private boolean unifiedShellEnabled;
        @JsonProperty(value="isIMSUser")
        private boolean userSupported;
        @JsonProperty(value="isImpersonated")
        private boolean userImpersonated;
        @JsonProperty(value="excludePatterns")
        private List<String> excludePatterns;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="customEnvLabel")
        private String customEnvLabel;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="metricsConfig")
        private Map<String, Object> metricsConfig;

        public boolean isUnifiedShellEnabled() {
            return this.unifiedShellEnabled;
        }

        public void setUnifiedShellEnabled(boolean unifiedShellEnabled) {
            this.unifiedShellEnabled = unifiedShellEnabled;
        }

        public boolean isUserSupported() {
            return this.userSupported;
        }

        public void setUserSupported(boolean userSupported) {
            this.userSupported = userSupported;
        }

        public boolean isUserImpersonated() {
            return this.userImpersonated;
        }

        public void setUserImpersonated(boolean userImpersonated) {
            this.userImpersonated = userImpersonated;
        }

        public List<String> getExcludePatterns() {
            return this.excludePatterns;
        }

        public void setExcludePatterns(List<String> excludePatterns) {
            this.excludePatterns = excludePatterns;
        }

        public String getCustomEnvLabel() {
            return this.customEnvLabel;
        }

        public void setCustomEnvLabel(String customEnvLabel) {
            this.customEnvLabel = customEnvLabel;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public Map<String, Object> getMetricsConfig() {
            return this.metricsConfig;
        }

        public void setMetricsConfig(Map<String, Object> metricsConfig) {
            this.metricsConfig = metricsConfig;
        }
    }
}

