/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.ui;

import com.adobe.cq.unifiedshell.impl.config.RepositoryIdentifier;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=unifiedshell/components/navrouter", "sling.servlet.resourceTypes=unifiedshell/components/renderconditions/navrouter", "sling.servlet.methods=GET"})
public class NavRouterServlet
extends SlingSafeMethodsServlet {
    public static final String RT_HANDLE_ROUTE = "unifiedshell/components/navrouter";
    public static final String RT_RENDER_CONDITION = "unifiedshell/components/renderconditions/navrouter";
    private static final Logger LOG = LoggerFactory.getLogger((String)NavRouterServlet.class.getName());
    private String repositoryId;
    private transient UnaryOperator<String> environmentVariableFunction = System::getenv;
    private List<String> allowedRoutes = Collections.unmodifiableList(Arrays.asList("/assets/dashboard"));

    @Activate
    public NavRouterServlet(@Reference RepositoryIdentifier repositoryIdentifier, @Reference(target="(toggle.name=FT_ASSETS-26712)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY) ToggleCondition toggleCondition) {
        this.repositoryId = repositoryIdentifier.getRepositoryId();
    }

    void setEnvironmentVariableFunction(UnaryOperator<String> environmentVariableFunction) {
        this.environmentVariableFunction = environmentVariableFunction;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (RT_RENDER_CONDITION.equals(request.getResource().getResourceType())) {
            this.doGetHandleRenderCondition(request);
        } else {
            this.doGetHandleRouter(request, response);
        }
    }

    void doGetHandleRouter(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String suffix = request.getRequestPathInfo().getSuffix();
        String imsOrg = this.getOrDefaultEnvironmentVariable("imsOrganization");
        String experienceCloudUIHostName = NavRouterServlet.getExperienceCloudUIHostName(this.getOrDefaultEnvironmentVariable("AEM_CM_TYPE"));
        if (suffix != null && !suffix.isEmpty() && this.allowedRoutes.contains(suffix)) {
            if (((Boolean)request.getResource().getValueMap().get("withRepoIdParam", (Object)Boolean.FALSE)).booleanValue()) {
                String targetURL = experienceCloudUIHostName + "?repoId=" + this.repositoryId + "#/@" + imsOrg + suffix;
                LOG.debug("NavRouterServlet redirecting to experience cloud ui with repoId param : {}", (Object)targetURL);
                response.sendRedirect(targetURL);
            } else {
                response.sendRedirect(experienceCloudUIHostName + "#/@" + imsOrg + suffix);
            }
            return;
        }
        response.setStatus(404);
    }

    static String getExperienceCloudUIHostName(String cmEnvType) {
        if ("dev".equals(cmEnvType)) {
            return "https://experience-qa.adobe.com/";
        }
        if ("stg".equals(cmEnvType)) {
            return "https://experience-stage.adobe.com/";
        }
        return "https://experience.adobe.com/";
    }

    void doGetHandleRenderCondition(@NotNull SlingHttpServletRequest request) {
        request.setAttribute(RenderCondition.class.getName(), (Object)new SimpleRenderCondition(!this.getOrDefaultEnvironmentVariable("imsOrganization").isEmpty()));
    }

    private String getOrDefaultEnvironmentVariable(String key) {
        if (this.environmentVariableFunction.apply(key) != null) {
            return (String)this.environmentVariableFunction.apply(key);
        }
        return "";
    }
}

