/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.ui;

import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.featureflags.Features;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"sling.servlet.prefix=/apps/", "sling.servlet.extensions=html", "sling.servlet.resourceTypes=sling/servlet/errorhandler", "sling.servlet.methods=404"})
@Designate(ocd=Config.class)
public class FrameErrorHandler
extends GenericServlet
implements OptingServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameErrorHandler.class);
    private static final String DEFAULT_ERROR_PAGE_PATH = "/libs/unifiedshell/content/frameerror";
    public static final String ATTR_IS_FRAME_ERROR = "com.adobe.cq.unifiedshell.frame_error_included";
    @Reference
    private Features features;
    private String refererPrefix;
    private String errorPagePath;

    @Activate
    protected void activate(Config config) {
        this.refererPrefix = config.refererPrefix();
        this.errorPagePath = config.errorPagePath();
    }

    boolean isServletConfigured() {
        return this.features.isEnabled("com.adobe.cq.unifiedshell.feature.flag") && this.refererPrefix != null && !this.refererPrefix.trim().isEmpty();
    }

    public boolean accepts(@NotNull SlingHttpServletRequest request) {
        return this.isServletConfigured() && this.shouldHandleRequest(request);
    }

    boolean shouldHandleRequest(SlingHttpServletRequest request) {
        return "GET".equals(request.getMethod()) && WCMMode.fromRequest((ServletRequest)request) != WCMMode.DISABLED && request.getAttribute(ATTR_IS_FRAME_ERROR) == null && request.getHeader("X-Requested-With") == null && Optional.ofNullable(request.getHeader("User-Agent")).filter(value -> value.contains("Mozilla") || value.contains("Opera")).isPresent() && !request.getRequestPathInfo().getResourcePath().startsWith(this.errorPagePath) && Optional.ofNullable(request.getHeader("Referer")).filter(value -> value.startsWith(this.refererPrefix)).isPresent() && request.getResourceResolver().getResource(this.errorPagePath) != null;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (servletRequest instanceof SlingHttpServletRequest && servletResponse instanceof SlingHttpServletResponse) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
            SlingHttpServletResponse response = (SlingHttpServletResponse)servletResponse;
            Integer scObject = (Integer)request.getAttribute("javax.servlet.error.status_code");
            int statusCode = Optional.ofNullable(scObject).orElse(500);
            if (response.isCommitted()) {
                LOGGER.warn("handleError: Response already committed; cannot send error for response status {}", (Object)statusCode);
                return;
            }
            response.reset();
            response.setStatus(statusCode);
            response.setContentType("text/html");
            response.setCharacterEncoding("utf-8");
            response.setHeader("x-aem-error-pass", "true");
            request.setAttribute(ATTR_IS_FRAME_ERROR, (Object)true);
            request.getRequestDispatcher(this.errorPagePath).include((ServletRequest)request, (ServletResponse)response);
        }
    }

    @ObjectClassDefinition(name="Unified Shell Frame Error Handler Servlet")
    public static @interface Config {
        @AttributeDefinition(description="Check 'Referer' header for this prefix to handle the request error.")
        public String refererPrefix() default "";

        @AttributeDefinition(description="The path to the page to render for handled request errors.", defaultValue={"/libs/unifiedshell/content/frameerror"})
        public String errorPagePath() default "/libs/unifiedshell/content/frameerror";
    }
}

