/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.discovery;

import com.adobe.cq.unifiedshell.impl.discovery.DiscoveryException;
import com.adobe.cq.unifiedshell.impl.discovery.ErrorType;
import java.io.IOException;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/unifiedshell/discovery", "sling.servlet.extensions=json"})
@Designate(ocd=Config.class)
public class DiscoveryServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiscoveryServlet.class.getName());
    private static final String HEADER_AUTH = "Authorization";
    private static final String AUTH_BEARER = "Bearer";
    private static final String PARAM_CONFIG_ID = "configid";
    private static final String AUTH_IMS = "ims";
    private static final String KEY_IMS_ORG = "imsOrg";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String APPLICATION_JSON = "application/json";
    private Config config;

    @Activate
    protected void activate(Config config) {
        this.config = config;
    }

    public void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        try {
            DiscoveryServlet.validateAuthorizationHeader(request);
            DiscoveryServlet.validateContentType(request);
            DiscoveryServlet.validateConfigId(request);
            JsonObjectBuilder json = Json.createObjectBuilder();
            Optional.ofNullable(this.config).map(Config::imsOrg).ifPresent(imsOrg -> json.add(KEY_IMS_ORG, imsOrg));
            DiscoveryServlet.sendJson(response, json.build());
        }
        catch (DiscoveryException e) {
            LOG.error("Failed to process discovery request", (Throwable)e);
            response.setStatus(400);
            DiscoveryServlet.sendJson(response, e.toJSON());
        }
    }

    static void validateAuthorizationHeader(@NotNull SlingHttpServletRequest request) {
        String auth = request.getHeader(HEADER_AUTH);
        if (auth != null) {
            String[] parts = auth.split(" ");
            if (parts.length != 2 || !AUTH_BEARER.equalsIgnoreCase(parts[0])) {
                throw new DiscoveryException(ErrorType.INVALID_AUTH_SCHEME);
            }
        } else {
            throw new DiscoveryException(ErrorType.MISSING_AUTH);
        }
    }

    static void validateContentType(@NotNull SlingHttpServletRequest request) {
        String contentType = request.getHeader(HEADER_CONTENT_TYPE);
        if (contentType == null) {
            throw new DiscoveryException(ErrorType.MISSING_CONTENT_TYPE);
        }
        if (!contentType.startsWith(APPLICATION_JSON)) {
            throw new DiscoveryException(ErrorType.INVALID_CONTENT_TYPE);
        }
    }

    static void validateConfigId(@NotNull SlingHttpServletRequest request) {
        RequestParameter configId = request.getRequestParameter(PARAM_CONFIG_ID);
        if (configId == null) {
            throw new DiscoveryException(ErrorType.MISSING_CONFIG_ID);
        }
        if (!AUTH_IMS.equals(configId.getString())) {
            throw new DiscoveryException(ErrorType.INVALID_CONFIG_ID);
        }
    }

    static void sendJson(@NotNull SlingHttpServletResponse response, @NotNull JsonObject json) throws IOException {
        response.setHeader(HEADER_CONTENT_TYPE, APPLICATION_JSON);
        response.getWriter().write(json.toString());
    }

    @ObjectClassDefinition(name="Unified Shell Discovery Servlet")
    public static @interface Config {
        @AttributeDefinition(name="IMS Organization", description="The value of imsOrg to return in successful servlet responses.")
        public String imsOrg() default "";
    }
}

