/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.config;

import com.adobe.cq.unifiedshell.impl.config.UnifiedShellConf;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UnifiedShellConfService.class, ResourceChangeListener.class}, immediate=true, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"resource.paths=/conf/global/settings/unifiedshell", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
@Designate(ocd=Config.class)
public class UnifiedShellConfService
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedShellConfService.class);
    public static final String SUBSERVICE = "unifiedshell-conf-service";
    public static final UnifiedShellConf DEFAULT_CONF = new UnifiedShellConf();
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference(target="(subServiceName=unifiedshell-conf-service)")
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private ModelFactory modelFactory;
    private UnifiedShellConf conf;
    private final AtomicLong lastRead = new AtomicLong(0L);
    private String productVersion;
    private List<String> excludePatterns;
    private long confRefreshIntervalMinutes;

    @Activate
    protected void activate(Config config) {
        this.productVersion = config.productVersion();
        this.excludePatterns = Arrays.asList(config.excludePatterns());
        this.confRefreshIntervalMinutes = config.confRefreshIntervalMinutes();
    }

    @NotNull
    public UnifiedShellConf getConf() {
        this.readConf(false);
        return Optional.ofNullable(this.conf).orElse(DEFAULT_CONF);
    }

    public void onChange(@NotNull List<ResourceChange> changes) {
        if (changes.stream().map(ResourceChange::getPath).anyMatch(path -> path.startsWith("/conf/global/settings/unifiedshell"))) {
            this.readConf(true);
        }
    }

    private void readConf(boolean forceRefresh) {
        long lastValue = this.lastRead.get();
        if (this.conf == null || forceRefresh || System.currentTimeMillis() - lastValue > 60000L * this.confRefreshIntervalMinutes) {
            try (ResourceResolver resolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SUBSERVICE));){
                Resource confRes = resolver.getResource("/conf/global/settings/unifiedshell");
                UnifiedShellConf newConf = Optional.ofNullable(confRes).map(resource -> (UnifiedShellConf)this.modelFactory.createModel((Object)confRes, UnifiedShellConf.class)).orElse(null);
                long completed = System.currentTimeMillis();
                if (newConf != null && (forceRefresh || this.lastRead.compareAndSet(lastValue, completed))) {
                    if (forceRefresh) {
                        this.lastRead.set(completed);
                    }
                    this.conf = newConf;
                }
            }
            catch (LoginException e) {
                LOGGER.error("[readConf] failed to login as service user.", (Throwable)e);
            }
        }
    }

    public String getProductVersion() {
        return this.productVersion != null ? this.productVersion : "";
    }

    public List<String> getExcludePatterns() {
        return Collections.unmodifiableList(this.excludePatterns);
    }

    @ObjectClassDefinition(name="Unified Shell Conf Service")
    public static @interface Config {
        @AttributeDefinition(name="Product Version", description="For unified shell EIM app identification")
        public String productVersion() default "";

        @AttributeDefinition(name="Exclude Patterns", description="Base list of window location patterns to exclude from redirect into the Unified Shell context")
        public String[] excludePatterns() default {"/libs/unifiedshell/content/settings/wizard.html", "linkshare.html", "linksharepreview.html", "assetpicker.html"};

        @AttributeDefinition(name="Conf Refresh Interval in Minutes", description="The conf will be loaded from the settings page at most once every X minutes.")
        public long confRefreshIntervalMinutes() default 5L;
    }
}

