/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.unifiedshell.impl.config;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RepositoryIdentifier.class}, immediate=true)
@Designate(ocd=RepositoryIdentifierConfig.class)
public class RepositoryIdentifier {
    private static final Logger log = LoggerFactory.getLogger(RepositoryIdentifier.class);
    protected static final String AEM_TIER_AUTHOR = "author";
    protected static final String AEM_TIER_PUBLISH = "publish";
    protected static final String AEM_TIER_GOLDEN_PUBLISH = "golden-publish";
    private final String repositoryId;

    @Activate
    public RepositoryIdentifier(RepositoryIdentifierConfig cfg) {
        this.repositoryId = Optional.ofNullable(cfg).map(config -> {
            String repositoryId;
            if (!config.repositoryId().isEmpty()) {
                repositoryId = config.repositoryId();
                log.info("Using repository ID from configuration: repositoryId={}", (Object)repositoryId);
            } else if (AEM_TIER_AUTHOR.equals(config.aemTier())) {
                repositoryId = config.aemDomainAuthor();
                log.info("Using repository ID from environment variables: aemTier={} repositoryId={}", (Object)config.aemTier(), (Object)repositoryId);
            } else if (AEM_TIER_GOLDEN_PUBLISH.equals(config.aemTier()) || AEM_TIER_PUBLISH.equals(config.aemTier())) {
                if (config.aemIsPreviewTier()) {
                    repositoryId = config.aemDomainPreview();
                    log.info("Using repository ID from environment variables: aemIsPreviewTier=true aemTier={} repositoryId={}", (Object)config.aemTier(), (Object)repositoryId);
                } else {
                    repositoryId = config.aemDomainPublish();
                    log.info("Using repository ID from environment variables: aemIsPreviewTier=false aemTier={} repositoryId={}", (Object)config.aemTier(), (Object)repositoryId);
                }
            } else if (!config.fallbackRepositoryId().isEmpty()) {
                repositoryId = config.fallbackRepositoryId();
                log.info("Using fallback repository ID, because aemTier is not supported for determination of repositoryId from environment: aemTier={} repositoryId={}", (Object)config.aemTier(), (Object)repositoryId);
            } else {
                repositoryId = null;
            }
            return repositoryId;
        }).orElse(null);
    }

    @Nullable
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ObjectClassDefinition
    public static @interface RepositoryIdentifierConfig {
        @AttributeDefinition(name="Override Repository ID", description="Explicitly the repository ID for this instance. Leave blank to determine the repository ID from environment variables.")
        public String repositoryId() default "";

        @AttributeDefinition(name="Fallback Repository ID", description="Specify a default repository ID to return when one cannot be determined from environment variables.")
        public String fallbackRepositoryId() default "";

        @AttributeDefinition(name="AEM Domain Author", description="The domain of the author service as defined by $[env:AEM_DOMAIN_AUTHOR;default=].")
        public String aemDomainAuthor() default "";

        @AttributeDefinition(name="AEM Domain Publish", description="The domain of the publish service as defined by $[env:AEM_DOMAIN_PUBLISH;default=].")
        public String aemDomainPublish() default "";

        @AttributeDefinition(name="AEM Domain Preview", description="The domain of the preview service as defined by $[env:AEM_DOMAIN_PREVIEW;default=].")
        public String aemDomainPreview() default "";

        @AttributeDefinition(name="AEM Tier", description="The value of $[env:AEM_TIER;default=] (author|golden-publish|publish|etc.).")
        public String aemTier() default "";

        @AttributeDefinition(name="AEM Is Preview Tier", description="The value of $[env:AEM_IS_PREVIEW_TIER;type=Boolean;default=false].")
        public boolean aemIsPreviewTier() default false;
    }
}

