/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.enums.ResultColumn;
import com.adobe.stock.models.SearchParameters;
import java.util.Arrays;
import java.util.HashSet;

public final class SearchFilesRequest {
    private String mLocale = "";
    private SearchParameters mSearchParams;
    private ResultColumn[] mResultColumns;
    private byte[] mSimilarImage;

    public String getLocale() {
        return this.mLocale;
    }

    public SearchFilesRequest setLocale(String locale) {
        if (locale == null || locale.isEmpty()) {
            throw new IllegalArgumentException("Should be a valid locale");
        }
        this.mLocale = locale;
        return this;
    }

    public SearchParameters getSearchParams() {
        return this.mSearchParams;
    }

    public SearchFilesRequest setSearchParams(SearchParameters searchParams) {
        if (searchParams == null) {
            throw new IllegalArgumentException("Search Params cannot be null");
        }
        this.mSearchParams = searchParams;
        return this;
    }

    public ResultColumn[] getResultColumns() {
        if (this.mResultColumns == null) {
            return null;
        }
        return (ResultColumn[])this.mResultColumns.clone();
    }

    public SearchFilesRequest setResultColumns(ResultColumn[] resultColumns) {
        if (resultColumns == null) {
            throw new IllegalArgumentException("Request Columns cannot be null");
        }
        HashSet<ResultColumn> resultColumnsSet = new HashSet<ResultColumn>();
        for (ResultColumn col : resultColumns) {
            resultColumnsSet.add(col);
        }
        this.mResultColumns = resultColumnsSet.toArray(new ResultColumn[resultColumnsSet.size()]);
        return this;
    }

    public byte[] getSimilarImage() {
        if (this.mSimilarImage == null) {
            return null;
        }
        return Arrays.copyOf(this.mSimilarImage, this.mSimilarImage.length);
    }

    public SearchFilesRequest setSimilarImage(byte[] similarImage) {
        if (similarImage == null) {
            throw new IllegalArgumentException("Should be a valid Image");
        }
        this.mSimilarImage = Arrays.copyOf(similarImage, similarImage.length);
        return this;
    }
}

