/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.LicenseContent;
import com.adobe.stock.models.LicenseEntitlement;
import com.adobe.stock.models.LicenseMemberInfo;
import com.adobe.stock.models.LicensePurchaseOptions;
import com.adobe.stock.models.LicenseReferenceResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class LicenseResponse {
    private LicenseEntitlement mEntitlement;
    private LicensePurchaseOptions mPurchaseOptions;
    private LicenseMemberInfo mMemberInfo;
    private ArrayList<LicenseReferenceResponse> mLicenseReferences;
    private Map<String, LicenseContent> mContentMap;

    public LicenseEntitlement getEntitlement() {
        return this.mEntitlement;
    }

    public LicensePurchaseOptions getPurchaseOptions() {
        return this.mPurchaseOptions;
    }

    public LicenseMemberInfo getMemberInfo() {
        return this.mMemberInfo;
    }

    public ArrayList<LicenseReferenceResponse> getLicenseReferences() {
        return this.mLicenseReferences;
    }

    public LicenseContent getContent(String contentId) throws StockException {
        if (this.mContentMap.containsKey(contentId)) {
            return this.mContentMap.get(contentId);
        }
        throw new StockException("Content not found for the given content id");
    }

    public ArrayList<LicenseContent> getContents() {
        ArrayList<LicenseContent> contentList = new ArrayList<LicenseContent>(this.mContentMap.values());
        return contentList;
    }

    @JsonSetter(value="available_entitlement")
    public void setEntitlement(LicenseEntitlement entitlement) {
        this.mEntitlement = entitlement;
    }

    @JsonSetter(value="purchase_options")
    public void setPurchaseOptions(LicensePurchaseOptions purchaseOptions) {
        this.mPurchaseOptions = purchaseOptions;
    }

    @JsonSetter(value="member")
    public void setMemberInfo(LicenseMemberInfo memberInfo) {
        this.mMemberInfo = memberInfo;
    }

    @JsonSetter(value="cce_agency")
    public void setLicenseReferences(ArrayList<LicenseReferenceResponse> licenseReferences) {
        this.mLicenseReferences = licenseReferences;
    }

    @JsonSetter(value="contents")
    public void setContent(JsonNode contentsNode) throws Exception {
        Iterator nodeIterator = contentsNode.fieldNames();
        ObjectMapper mapper = new ObjectMapper();
        this.mContentMap = new HashMap<String, LicenseContent>();
        while (nodeIterator.hasNext()) {
            String key = (String)nodeIterator.next();
            JsonNode contentNode = contentsNode.get(key);
            LicenseContent licenseContent = (LicenseContent)mapper.readValue(contentNode.toString(), LicenseContent.class);
            this.mContentMap.put(key, licenseContent);
        }
    }
}

