/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.enums.LicenseHistoryResultColumn;
import com.adobe.stock.models.SearchParametersLicenseHistory;
import java.util.HashSet;

public final class LicenseHistoryRequest {
    private String mLocale = "";
    private SearchParametersLicenseHistory mSearchParams;
    private LicenseHistoryResultColumn[] mResultColumns;

    public String getLocale() {
        return this.mLocale;
    }

    public LicenseHistoryRequest setLocale(String locale) {
        if (locale == null || locale.isEmpty()) {
            throw new IllegalArgumentException("Should be a valid locale");
        }
        this.mLocale = locale;
        return this;
    }

    public SearchParametersLicenseHistory getSearchParams() {
        return this.mSearchParams;
    }

    public LicenseHistoryRequest setSearchParams(SearchParametersLicenseHistory searchParams) {
        if (searchParams == null) {
            throw new IllegalArgumentException("Search Params cannot be null");
        }
        this.mSearchParams = searchParams;
        return this;
    }

    public LicenseHistoryResultColumn[] getResultColumns() {
        return this.mResultColumns;
    }

    public LicenseHistoryRequest setResultColumns(LicenseHistoryResultColumn[] resultColumns) {
        if (resultColumns == null) {
            throw new IllegalArgumentException("Request Columns cannot be null");
        }
        HashSet<LicenseHistoryResultColumn> resultColumnsSet = new HashSet<LicenseHistoryResultColumn>();
        for (LicenseHistoryResultColumn col : resultColumns) {
            resultColumnsSet.add(col);
        }
        this.mResultColumns = resultColumnsSet.toArray(new LicenseHistoryResultColumn[resultColumnsSet.size()]);
        return this;
    }
}

