/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.config;

import com.adobe.stock.enums.Environment;
import com.adobe.stock.exception.StockException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Endpoints {
    private static final String SEARCH_FILES_ENDPOINT_KEY = "api.endpoints.search";
    private static final String SEARCH_CATEGORY_ENDPOINT_KEY = "api.endpoints.category";
    private static final String SEARCH_CATEGORY_TREE_ENDPOINT_KEY = "api.endpoints.categorytree";
    private static final String LICENSE_CONTENT_INFO_ENDPOINT_KEY = "api.endpoints.license.contentinfo";
    private static final String LICENSE_CONTENT_LICENSE_ENDPOINT_KEY = "api.endpoints.license.contentlicense";
    private static final String LICENSE_MEMBER_PROFILE_ENDPOINT_KEY = "api.endpoints.license.memberprofile";
    private static final String LICENSE_MEMBER_ABANDON_ENDPOINT_KEY = "api.endpoints.license.memberabandon";
    private static final String LICENSE_HISTORY_ENDPOINT_KEY = "api.endpoints.licensehistory";
    private static final String LIST_ENTITLEMENT_ENDPOINT_KEY = "api.endpoints.entitlementlist";
    private static final String SELECT_ENTITLEMENT_ENDPOINT_KEY = "api.endpoints.selectentitlement";
    private static final String PROPS_FILE_PROD = "prod-environment.properties";
    private static final String PROPS_FILE_STAGE = "stage-environment.properties";
    private static final String PROPS_FILE_LOCAL = "local-environment.properties";
    private Environment mEnvironment;
    private Properties mEndpoints;

    public Endpoints(Environment env) throws StockException {
        if (env == null) {
            throw new StockException("Environment can't be null");
        }
        InputStream input = null;
        try {
            if (env == Environment.PROD) {
                input = Endpoints.getResourceAsStream(PROPS_FILE_PROD);
            } else if (env == Environment.STAGE) {
                input = Endpoints.getResourceAsStream(PROPS_FILE_STAGE);
            } else if (env == Environment.LOCAL) {
                input = Endpoints.getResourceAsStream(PROPS_FILE_LOCAL);
            }
            if (input == null) {
                throw new StockException("Could not load the endpoint properties file");
            }
            this.mEnvironment = env;
            this.mEndpoints = new Properties();
            this.mEndpoints.load(input);
        }
        catch (StockException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StockException("Could not initialize the endpoints");
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new StockException("Could not load the endpoint properties file");
            }
        }
    }

    private static InputStream getResourceAsStream(String resource) {
        return Endpoints.class.getClassLoader().getResourceAsStream(resource);
    }

    public final String getSearchFilesEndpoint() {
        return this.mEndpoints.getProperty(SEARCH_FILES_ENDPOINT_KEY);
    }

    public final String getSearchCategoryEndpoint() {
        return this.mEndpoints.getProperty(SEARCH_CATEGORY_ENDPOINT_KEY);
    }

    public final String getSearchCategoryTreeEndpoint() {
        return this.mEndpoints.getProperty(SEARCH_CATEGORY_TREE_ENDPOINT_KEY);
    }

    public final String getLicenseContentInfoEndpoint() {
        return this.mEndpoints.getProperty(LICENSE_CONTENT_INFO_ENDPOINT_KEY);
    }

    public final String getLicenseContentLicenseEndpoint() {
        return this.mEndpoints.getProperty(LICENSE_CONTENT_LICENSE_ENDPOINT_KEY);
    }

    public final String getLicenseMemberProfileEndpoint() {
        return this.mEndpoints.getProperty(LICENSE_MEMBER_PROFILE_ENDPOINT_KEY);
    }

    public final String getLicenseMemberAbandonEndpoint() {
        return this.mEndpoints.getProperty(LICENSE_MEMBER_ABANDON_ENDPOINT_KEY);
    }

    public final String getLicenseHistoryEndpoint() {
        return this.mEndpoints.getProperty(LICENSE_HISTORY_ENDPOINT_KEY);
    }

    public final String getEntitlementListEndPoint() {
        return this.mEndpoints.getProperty(LIST_ENTITLEMENT_ENDPOINT_KEY);
    }

    public final String getSelectEntitlementEndpoint() {
        return this.mEndpoints.getProperty(SELECT_ENTITLEMENT_ENDPOINT_KEY);
    }

    public final Environment getEnvironment() {
        return this.mEnvironment;
    }
}

