/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.ApiUtils;
import com.adobe.stock.apis.EntitlementsApiHelper;
import com.adobe.stock.apis.HttpUtils;
import com.adobe.stock.apis.JsonUtils;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.EntitlementList;
import java.util.Map;
import org.apache.http.entity.ContentType;

public final class Entitlements {
    private static final String ENTITLEMENT_GUID_PARAM = "entitlement_guid";
    private StockConfig mConfig;

    public Entitlements(StockConfig config) throws StockException {
        if (config == null) {
            throw new StockException("Config can't be null");
        }
        this.mConfig = new StockConfig().setApiKey(config.getApiKey()).setProduct(config.getProduct()).setTargetEnvironment(config.getTargetEnvironment()).setProductLocation(config.getProductLocation());
    }

    public EntitlementList listEntitlements(String accessToken, String entityReference) throws StockException {
        String requestURL = EntitlementsApiHelper.createApiURL(this.mConfig.getEndpoints().getEntitlementListEndPoint(), accessToken, entityReference);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        String responseString = HttpUtils.doGet(requestURL, headers);
        EntitlementList reponse = (EntitlementList)JsonUtils.parseJson(EntitlementList.class, responseString);
        return reponse;
    }

    public void selectEntitlement(String accessToken, String entitlementGuid, String entityReference) throws StockException {
        String params = "";
        String requestURL = EntitlementsApiHelper.createApiURL(this.mConfig.getEndpoints().getSelectEntitlementEndpoint(), accessToken, entityReference);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        if (entitlementGuid != null && !entitlementGuid.isEmpty()) {
            params = "entitlement_guid=" + entitlementGuid;
        }
        HttpUtils.doPost(requestURL, headers, params.getBytes(), ContentType.APPLICATION_FORM_URLENCODED);
    }
}

