/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.tags;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.ServletResponseHelper;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.VariationConstants;
import com.adobe.cq.dam.cfm.impl.Constants;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.TagList;
import com.adobe.cq.dam.cfm.openapi.models.TagsRequest;
import com.adobe.cq.dam.cfm.tags.TagsHelper;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTagsProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractTagsProcessor.class);
    public static final String EXCEPTION_MSG_FORBIDDEN = "User is not allowed to modify tags on this fragment.";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTagsProcessor.class);
    protected static final String INVALID_VARIATION_NAME = "Invalid variation name.";
    protected static final String INVALID_FRAGMENT_ID = "Invalid fragment id.";
    protected static final String EXCEPTION_MSG_TAG_NOT_VALID = "Tag id(s) not valid: %s.";
    protected static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Content Fragment with id '%s' could not be found or it can not be adapted to a Content Fragment.";
    private static final String TAGS = "/tags";
    protected static final Pattern THIS_PROCESSOR_URL_PATTERN = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/tags", 2);
    protected static final Pattern THIS_MODEL_PROCESSOR_URL_PATTERN_TAGS = Pattern.compile(Constants.CFM_ID_REQUEST_PATTERN + "/tags", 2);
    private static final String VARIATIONS = "/variations";
    protected static final Pattern THIS_PROCESSOR_URL_PATTERN_VARIATIONS = Pattern.compile("/" + Utils.UUID_REGEX_PATTERN_RAW + "/variations/" + VariationConstants.VARIATION_PATTERN + "/tags", 2);
    protected static final String MISSING_TAG_MANAGER = "The TagManager cannot be accessed by the current session.";
    @Reference
    protected RequestValidator requestValidator;
    @Reference
    protected ETagService eTagService;
    @Reference
    protected JsonDataProcessor jsonDataProcessor;

    protected abstract boolean processWithExceptions(@NotNull Request var1, @NotNull Response var2) throws IOException, ContentFragmentException, ETagException;

    protected abstract String getGenericErrorMessage();

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        try {
            if (this.validateHeaders(request, response)) {
                return this.processWithExceptions(request, response);
            }
            return false;
        }
        catch (ContentFragmentException | ETagException | PersistenceException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)e.getMessage()));
            return true;
        }
    }

    protected boolean validateHeaders(Request request, Response response) throws ETagException, IOException {
        if (!ServletResponseHelper.isHeaderValueMatching(request, "Accept", ContentType.APPLICATION_JSON.getMimeType())) {
            response.endWithProblem(ProblemDetails.notAcceptable((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: application/json' request header.", "Accept")), true);
            return false;
        }
        String ifMatchHeader = request.getHeader("If-Match");
        if ((request.isPut() || request.isDelete()) && StringUtils.isEmpty((CharSequence)ifMatchHeader)) {
            response.endWithProblem(ProblemDetails.preconditionRequired((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The %s conditional request header is mandatory.", "If-Match")));
            return false;
        }
        return true;
    }

    protected boolean isNotModifiable(@NotNull Resource resource) {
        return resource.adaptTo(ModifiableValueMap.class) == null;
    }

    protected String getVariationNameFromRequest(Matcher matcher) {
        String variationName = matcher.group(2);
        return variationName != null ? ResourceUtil.normalize((String)variationName) : null;
    }

    protected Resource getFragmentResource(Request request, String id) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        return Utils.getResourceByUuid(id, resourceResolver);
    }

    protected ContentFragment getContentFragment(Resource resource) {
        return (ContentFragment)resource.adaptTo(ContentFragment.class);
    }

    @Nullable
    protected Set<Tag> getTagsFromPayloadOrEndResponse(@NotNull Request request, @NotNull Response response, @NotNull TagManager tagManager) throws IOException {
        TagsRequest tagsFromPayload = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), TagsRequest.class);
        List<String> validationMessages = this.requestValidator.getValidationMessages(tagsFromPayload);
        if (!validationMessages.isEmpty()) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
            return null;
        }
        HashSet<String> invalidTags = new HashSet<String>(tagsFromPayload.getTags());
        HashSet<Tag> validTags = new HashSet<Tag>();
        for (String tag : tagsFromPayload.getTags()) {
            Tag resolvedTag = tagManager.resolve(tag);
            if (resolvedTag == null) continue;
            validTags.add(resolvedTag);
            invalidTags.remove(tag);
        }
        if (invalidTags.isEmpty()) {
            return validTags;
        }
        response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format(EXCEPTION_MSG_TAG_NOT_VALID, invalidTags)));
        return null;
    }

    protected Tag[] getMergedTags(Set<Tag> tagsFromPayload, Set<Tag> fragmentTags) {
        HashSet<Tag> mergedTags = new HashSet<Tag>(fragmentTags);
        mergedTags.addAll(tagsFromPayload);
        return mergedTags.toArray(new Tag[0]);
    }

    @NotNull
    protected TagList convertTags(@NotNull Tag[] tags) {
        return new TagList().items(Arrays.stream(tags).map(TagsHelper::map).collect(Collectors.toList()));
    }
}

