/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.impl.servlets.validators.Regex;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import java.util.Objects;

@JsonTypeName(value="TextModelField")
public class TextModelField
extends ContentFragmentModelField {
    @Valid
    private String placeholder;
    @Valid
    private String defaultValue;
    @Valid
    private Integer maxLength;
    @Valid
    private Boolean unique;
    @Valid
    private Boolean translatable;
    @Valid
    private ValidationTypeEnum validationType = ValidationTypeEnum.NONE;
    @Regex
    @Valid
    private String customValidationRegex;
    @Valid
    private String customErrorMessage;

    public TextModelField placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @JsonProperty(value="placeholder")
    public String getPlaceholder() {
        return this.placeholder;
    }

    @JsonProperty(value="placeholder")
    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public TextModelField defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @JsonProperty(value="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="defaultValue")
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public TextModelField maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @JsonProperty(value="maxLength")
    @Min(value=0L)
    public @Min(value=0L) Integer getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="maxLength")
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public TextModelField unique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    @JsonProperty(value="unique")
    public Boolean getUnique() {
        return this.unique;
    }

    @JsonProperty(value="unique")
    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public TextModelField translatable(Boolean translatable) {
        this.translatable = translatable;
        return this;
    }

    @JsonProperty(value="translatable")
    public Boolean getTranslatable() {
        return this.translatable;
    }

    @JsonProperty(value="translatable")
    public void setTranslatable(Boolean translatable) {
        this.translatable = translatable;
    }

    public TextModelField validationType(ValidationTypeEnum validationType) {
        this.validationType = validationType;
        return this;
    }

    @JsonProperty(value="validationType")
    public ValidationTypeEnum getValidationType() {
        return this.validationType;
    }

    @JsonProperty(value="validationType")
    public void setValidationType(ValidationTypeEnum validationType) {
        this.validationType = validationType;
    }

    public TextModelField customValidationRegex(String customValidationRegex) {
        this.customValidationRegex = customValidationRegex;
        return this;
    }

    @JsonProperty(value="customValidationRegex")
    public String getCustomValidationRegex() {
        return this.customValidationRegex;
    }

    @JsonProperty(value="customValidationRegex")
    public void setCustomValidationRegex(String customValidationRegex) {
        this.customValidationRegex = customValidationRegex;
    }

    public TextModelField customErrorMessage(String customErrorMessage) {
        this.customErrorMessage = customErrorMessage;
        return this;
    }

    @JsonProperty(value="customErrorMessage")
    public String getCustomErrorMessage() {
        return this.customErrorMessage;
    }

    @JsonProperty(value="customErrorMessage")
    public void setCustomErrorMessage(String customErrorMessage) {
        this.customErrorMessage = customErrorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextModelField textModelField = (TextModelField)o;
        return Objects.equals(this.placeholder, textModelField.placeholder) && Objects.equals(this.defaultValue, textModelField.defaultValue) && Objects.equals(this.maxLength, textModelField.maxLength) && Objects.equals(this.unique, textModelField.unique) && Objects.equals(this.translatable, textModelField.translatable) && Objects.equals((Object)this.validationType, (Object)textModelField.validationType) && Objects.equals(this.customValidationRegex, textModelField.customValidationRegex) && Objects.equals(this.customErrorMessage, textModelField.customErrorMessage) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.placeholder, this.defaultValue, this.maxLength, this.unique, this.translatable, this.validationType, this.customValidationRegex, this.customErrorMessage, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextModelField {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    placeholder: ").append(this.toIndentedString(this.placeholder)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    unique: ").append(this.toIndentedString(this.unique)).append("\n");
        sb.append("    translatable: ").append(this.toIndentedString(this.translatable)).append("\n");
        sb.append("    validationType: ").append(this.toIndentedString((Object)this.validationType)).append("\n");
        sb.append("    customValidationRegex: ").append(this.toIndentedString(this.customValidationRegex)).append("\n");
        sb.append("    customErrorMessage: ").append(this.toIndentedString(this.customErrorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValidationTypeEnum {
        NONE(String.valueOf("none")),
        EMAIL(String.valueOf("email")),
        URL(String.valueOf("url")),
        CUSTOM(String.valueOf("custom"));

        private String value;

        private ValidationTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static ValidationTypeEnum fromString(String s) {
            for (ValidationTypeEnum b : ValidationTypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static ValidationTypeEnum fromValue(String value) {
            for (ValidationTypeEnum b : ValidationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

