/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="TagsRequest")
public class TagsRequest {
    @Valid
    private List<String> tags = new ArrayList<String>();

    public TagsRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="tags")
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<@Pattern(regexp="^(?:(?!\\.|%|\\*|\\?|\\[|\\]|\\|).)*$") String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public TagsRequest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public TagsRequest removeTagsItem(String tagsItem) {
        if (tagsItem != null && this.tags != null) {
            this.tags.remove(tagsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagsRequest tagsRequest = (TagsRequest)o;
        return Objects.equals(this.tags, tagsRequest.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TagsRequest {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

