/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JsonTypeName(value="TagFragmentField")
public class TagFragmentField
extends ContentFragmentField {
    @Valid
    private Set<String> values;

    public TagFragmentField values(Set<String> values) {
        this.values = values;
        return this;
    }

    @Override
    @JsonProperty(value="values")
    public Set<@Pattern(regexp="^(?:(?!\\.|%|\\*|\\?|\\[|\\]|\\|).)*$") String> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setValues(Set<String> values) {
        this.values = values;
    }

    public TagFragmentField addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new LinkedHashSet<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    public TagFragmentField removeValuesItem(String valuesItem) {
        if (valuesItem != null && this.values != null) {
            this.values.remove(valuesItem);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagFragmentField tagFragmentField = (TagFragmentField)o;
        return Objects.equals(this.values, tagFragmentField.values) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.values, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TagFragmentField {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

