/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.Permission;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="PermissionsRequest")
public class PermissionsRequest {
    @Valid
    private List<String> paths = new ArrayList<String>();
    @Valid
    private List<Permission> preferredPermissions;

    public PermissionsRequest paths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    @JsonProperty(value="paths")
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getPaths() {
        return this.paths;
    }

    @JsonProperty(value="paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public PermissionsRequest addPathsItem(String pathsItem) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(pathsItem);
        return this;
    }

    public PermissionsRequest removePathsItem(String pathsItem) {
        if (pathsItem != null && this.paths != null) {
            this.paths.remove(pathsItem);
        }
        return this;
    }

    public PermissionsRequest preferredPermissions(List<Permission> preferredPermissions) {
        this.preferredPermissions = preferredPermissions;
        return this;
    }

    @JsonProperty(value="preferredPermissions")
    public List<Permission> getPreferredPermissions() {
        return this.preferredPermissions;
    }

    @JsonProperty(value="preferredPermissions")
    public void setPreferredPermissions(List<Permission> preferredPermissions) {
        this.preferredPermissions = preferredPermissions;
    }

    public PermissionsRequest addPreferredPermissionsItem(Permission preferredPermissionsItem) {
        if (this.preferredPermissions == null) {
            this.preferredPermissions = new ArrayList<Permission>();
        }
        this.preferredPermissions.add(preferredPermissionsItem);
        return this;
    }

    public PermissionsRequest removePreferredPermissionsItem(Permission preferredPermissionsItem) {
        if (preferredPermissionsItem != null && this.preferredPermissions != null) {
            this.preferredPermissions.remove((Object)preferredPermissionsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionsRequest permissionsRequest = (PermissionsRequest)o;
        return Objects.equals(this.paths, permissionsRequest.paths) && Objects.equals(this.preferredPermissions, permissionsRequest.preferredPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.preferredPermissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionsRequest {\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("    preferredPermissions: ").append(this.toIndentedString(this.preferredPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

