/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonTypeName(value="ParentReference")
public class ParentReference {
    @Valid
    private TypeEnum type;
    @Valid
    private String title;
    @Valid
    private String path;
    @Valid
    private ResourceStatus status;

    public ParentReference type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ParentReference title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public ParentReference path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public ParentReference status(ResourceStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @NotNull
    public ResourceStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(ResourceStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentReference parentReference = (ParentReference)o;
        return Objects.equals((Object)this.type, (Object)parentReference.type) && Objects.equals(this.title, parentReference.title) && Objects.equals(this.path, parentReference.path) && Objects.equals((Object)this.status, (Object)parentReference.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.title, this.path, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParentReference {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CONTENT_FRAGMENT(String.valueOf("content-fragment")),
        EXPERIENCE_FRAGMENT(String.valueOf("experience-fragment")),
        PAGE(String.valueOf("page"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromString(String s) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

