/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public enum MimeType {
    HTML("text/html"),
    PLAIN("text/plain"),
    X_MARKDOWN("text/x-markdown"),
    MARKDOWN("text/markdown");

    private String value;

    private MimeType(String value) {
        this.value = value;
    }

    public static MimeType fromString(String s) {
        for (MimeType b : MimeType.values()) {
            if (!Objects.toString(b.value).equals(s)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static MimeType fromValue(String value) {
        for (MimeType b : MimeType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

