/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="fragments_findAndReplace_request")
public class FragmentsFindAndReplaceRequest {
    @Valid
    private List<String> paths = new ArrayList<String>();
    @Valid
    private String find;
    @Valid
    private String replace;
    @Valid
    private Boolean dryRun;
    @Valid
    private Boolean ignoreErrors;

    public FragmentsFindAndReplaceRequest paths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    @JsonProperty(value="paths")
    @NotNull
    @Size(max=20)
    public @NotNull @Size(max=20) List<@Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String> getPaths() {
        return this.paths;
    }

    @JsonProperty(value="paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public FragmentsFindAndReplaceRequest addPathsItem(String pathsItem) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(pathsItem);
        return this;
    }

    public FragmentsFindAndReplaceRequest removePathsItem(String pathsItem) {
        if (pathsItem != null && this.paths != null) {
            this.paths.remove(pathsItem);
        }
        return this;
    }

    public FragmentsFindAndReplaceRequest find(String find) {
        this.find = find;
        return this;
    }

    @JsonProperty(value="find")
    @NotNull
    @Pattern(regexp="^[^<>]*$")
    public @NotNull @Pattern(regexp="^[^<>]*$") String getFind() {
        return this.find;
    }

    @JsonProperty(value="find")
    public void setFind(String find) {
        this.find = find;
    }

    public FragmentsFindAndReplaceRequest replace(String replace) {
        this.replace = replace;
        return this;
    }

    @JsonProperty(value="replace")
    @NotNull
    @Pattern(regexp="^[^<>]*$")
    public @NotNull @Pattern(regexp="^[^<>]*$") String getReplace() {
        return this.replace;
    }

    @JsonProperty(value="replace")
    public void setReplace(String replace) {
        this.replace = replace;
    }

    public FragmentsFindAndReplaceRequest dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty(value="dryRun")
    @NotNull
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public FragmentsFindAndReplaceRequest ignoreErrors(Boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return this;
    }

    @JsonProperty(value="ignoreErrors")
    @NotNull
    public Boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    @JsonProperty(value="ignoreErrors")
    public void setIgnoreErrors(Boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentsFindAndReplaceRequest fragmentsFindAndReplaceRequest = (FragmentsFindAndReplaceRequest)o;
        return Objects.equals(this.paths, fragmentsFindAndReplaceRequest.paths) && Objects.equals(this.find, fragmentsFindAndReplaceRequest.find) && Objects.equals(this.replace, fragmentsFindAndReplaceRequest.replace) && Objects.equals(this.dryRun, fragmentsFindAndReplaceRequest.dryRun) && Objects.equals(this.ignoreErrors, fragmentsFindAndReplaceRequest.ignoreErrors);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.find, this.replace, this.dryRun, this.ignoreErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FragmentsFindAndReplaceRequest {\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("    find: ").append(this.toIndentedString(this.find)).append("\n");
        sb.append("    replace: ").append(this.toIndentedString(this.replace)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    ignoreErrors: ").append(this.toIndentedString(this.ignoreErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

