/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.impl.servlets.validators.RequiredFragmentReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="FragmentReferenceModelField")
@RequiredFragmentReference
public class FragmentReferenceModelField
extends ContentFragmentModelField {
    @Valid
    private String placeholder;
    @Valid
    private String defaultValue;
    @Valid
    private String root;
    @Valid
    private Boolean allowFragmentCreation = true;
    @Valid
    private List<String> items;
    @Valid
    private List<String> tags;

    public FragmentReferenceModelField placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @JsonProperty(value="placeholder")
    public String getPlaceholder() {
        return this.placeholder;
    }

    @JsonProperty(value="placeholder")
    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public FragmentReferenceModelField defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @JsonProperty(value="defaultValue")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="defaultValue")
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public FragmentReferenceModelField root(String root) {
        this.root = root;
        return this;
    }

    @JsonProperty(value="root")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getRoot() {
        return this.root;
    }

    @JsonProperty(value="root")
    public void setRoot(String root) {
        this.root = root;
    }

    public FragmentReferenceModelField allowFragmentCreation(Boolean allowFragmentCreation) {
        this.allowFragmentCreation = allowFragmentCreation;
        return this;
    }

    @JsonProperty(value="allowFragmentCreation")
    public Boolean getAllowFragmentCreation() {
        return this.allowFragmentCreation;
    }

    @JsonProperty(value="allowFragmentCreation")
    public void setAllowFragmentCreation(Boolean allowFragmentCreation) {
        this.allowFragmentCreation = allowFragmentCreation;
    }

    public FragmentReferenceModelField items(List<String> items) {
        this.items = items;
        return this;
    }

    @JsonProperty(value="items")
    public List<String> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    public void setItems(List<String> items) {
        this.items = items;
    }

    public FragmentReferenceModelField addItemsItem(String itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<String>();
        }
        this.items.add(itemsItem);
        return this;
    }

    public FragmentReferenceModelField removeItemsItem(String itemsItem) {
        if (itemsItem != null && this.items != null) {
            this.items.remove(itemsItem);
        }
        return this;
    }

    public FragmentReferenceModelField tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="tags")
    public List<@Pattern(regexp="^(?:(?!\\.|%|\\*|\\?|\\[|\\]|\\|).)*$") String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FragmentReferenceModelField addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public FragmentReferenceModelField removeTagsItem(String tagsItem) {
        if (tagsItem != null && this.tags != null) {
            this.tags.remove(tagsItem);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentReferenceModelField fragmentReferenceModelField = (FragmentReferenceModelField)o;
        return Objects.equals(this.placeholder, fragmentReferenceModelField.placeholder) && Objects.equals(this.defaultValue, fragmentReferenceModelField.defaultValue) && Objects.equals(this.root, fragmentReferenceModelField.root) && Objects.equals(this.allowFragmentCreation, fragmentReferenceModelField.allowFragmentCreation) && Objects.equals(this.items, fragmentReferenceModelField.items) && Objects.equals(this.tags, fragmentReferenceModelField.tags) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.placeholder, this.defaultValue, this.root, this.allowFragmentCreation, this.items, this.tags, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FragmentReferenceModelField {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    placeholder: ").append(this.toIndentedString(this.placeholder)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("    allowFragmentCreation: ").append(this.toIndentedString(this.allowFragmentCreation)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

