/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public enum DataType {
    TEXT("text"),
    LONG_TEXT("long-text"),
    NUMBER("number"),
    FLOAT_NUMBER("float-number"),
    DATE_TIME("date-time"),
    DATE("date"),
    TIME("time"),
    BOOLEAN("boolean"),
    ENUMERATION("enumeration"),
    TAG("tag"),
    CONTENT_FRAGMENT("content-fragment"),
    CONTENT_REFERENCE("content-reference"),
    JSON("json");

    private String value;

    private DataType(String value) {
        this.value = value;
    }

    public static DataType fromString(String s) {
        for (DataType b : DataType.values()) {
            if (!Objects.toString(b.value).equals(s)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static DataType fromValue(String value) {
        for (DataType b : DataType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

