/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="CreateContentFragment")
public class CreateContentFragment {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private String modelId;
    @Valid
    private String parentPath;
    @Valid
    private String name;
    @Valid
    private List<ContentFragmentField> fields;

    public CreateContentFragment title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public CreateContentFragment description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateContentFragment modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    @JsonProperty(value="modelId")
    @NotNull
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="modelId")
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public CreateContentFragment parentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @JsonProperty(value="parentPath")
    @NotNull
    @Pattern(regexp="^([//a-zA-Z0-9_:~\\-.']+)+$")
    public @NotNull @Pattern(regexp="^([//a-zA-Z0-9_:~\\-.']+)+$") String getParentPath() {
        return this.parentPath;
    }

    @JsonProperty(value="parentPath")
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public CreateContentFragment name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateContentFragment fields(List<ContentFragmentField> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty(value="fields")
    public List<ContentFragmentField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<ContentFragmentField> fields) {
        this.fields = fields;
    }

    public CreateContentFragment addFieldsItem(ContentFragmentField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ContentFragmentField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    public CreateContentFragment removeFieldsItem(ContentFragmentField fieldsItem) {
        if (fieldsItem != null && this.fields != null) {
            this.fields.remove(fieldsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateContentFragment createContentFragment = (CreateContentFragment)o;
        return Objects.equals(this.title, createContentFragment.title) && Objects.equals(this.description, createContentFragment.description) && Objects.equals(this.modelId, createContentFragment.modelId) && Objects.equals(this.parentPath, createContentFragment.parentPath) && Objects.equals(this.name, createContentFragment.name) && Objects.equals(this.fields, createContentFragment.fields);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.modelId, this.parentPath, this.name, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateContentFragment {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    modelId: ").append(this.toIndentedString(this.modelId)).append("\n");
        sb.append("    parentPath: ").append(this.toIndentedString(this.parentPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

