/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentType;
import com.adobe.cq.dam.cfm.openapi.models.FileSize;
import com.adobe.cq.dam.cfm.openapi.models.MinMax;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="ContentReferenceModelField")
public class ContentReferenceModelField
extends ContentFragmentModelField {
    @Valid
    private String placeholder;
    @Valid
    private Boolean showThumbnail = false;
    @Valid
    private String root;
    @Valid
    private String defaultValue;
    @Valid
    private MinMax imageWidth;
    @Valid
    private MinMax imageHeight;
    @Valid
    private FileSize fileSizeMin;
    @Valid
    private FileSize fileSizeMax;
    @Valid
    private List<ContentType> allowedContentTypes;

    public ContentReferenceModelField placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @JsonProperty(value="placeholder")
    public String getPlaceholder() {
        return this.placeholder;
    }

    @JsonProperty(value="placeholder")
    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public ContentReferenceModelField showThumbnail(Boolean showThumbnail) {
        this.showThumbnail = showThumbnail;
        return this;
    }

    @JsonProperty(value="showThumbnail")
    public Boolean getShowThumbnail() {
        return this.showThumbnail;
    }

    @JsonProperty(value="showThumbnail")
    public void setShowThumbnail(Boolean showThumbnail) {
        this.showThumbnail = showThumbnail;
    }

    public ContentReferenceModelField root(String root) {
        this.root = root;
        return this;
    }

    @JsonProperty(value="root")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getRoot() {
        return this.root;
    }

    @JsonProperty(value="root")
    public void setRoot(String root) {
        this.root = root;
    }

    public ContentReferenceModelField defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @JsonProperty(value="defaultValue")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="defaultValue")
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ContentReferenceModelField imageWidth(MinMax imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    @JsonProperty(value="imageWidth")
    public MinMax getImageWidth() {
        return this.imageWidth;
    }

    @JsonProperty(value="imageWidth")
    public void setImageWidth(MinMax imageWidth) {
        this.imageWidth = imageWidth;
    }

    public ContentReferenceModelField imageHeight(MinMax imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    @JsonProperty(value="imageHeight")
    public MinMax getImageHeight() {
        return this.imageHeight;
    }

    @JsonProperty(value="imageHeight")
    public void setImageHeight(MinMax imageHeight) {
        this.imageHeight = imageHeight;
    }

    public ContentReferenceModelField fileSizeMin(FileSize fileSizeMin) {
        this.fileSizeMin = fileSizeMin;
        return this;
    }

    @JsonProperty(value="fileSizeMin")
    public FileSize getFileSizeMin() {
        return this.fileSizeMin;
    }

    @JsonProperty(value="fileSizeMin")
    public void setFileSizeMin(FileSize fileSizeMin) {
        this.fileSizeMin = fileSizeMin;
    }

    public ContentReferenceModelField fileSizeMax(FileSize fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
        return this;
    }

    @JsonProperty(value="fileSizeMax")
    public FileSize getFileSizeMax() {
        return this.fileSizeMax;
    }

    @JsonProperty(value="fileSizeMax")
    public void setFileSizeMax(FileSize fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public ContentReferenceModelField allowedContentTypes(List<ContentType> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
        return this;
    }

    @JsonProperty(value="allowedContentTypes")
    @Size(min=1)
    public @Size(min=1) List<ContentType> getAllowedContentTypes() {
        return this.allowedContentTypes;
    }

    @JsonProperty(value="allowedContentTypes")
    public void setAllowedContentTypes(List<ContentType> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
    }

    public ContentReferenceModelField addAllowedContentTypesItem(ContentType allowedContentTypesItem) {
        if (this.allowedContentTypes == null) {
            this.allowedContentTypes = new ArrayList<ContentType>();
        }
        this.allowedContentTypes.add(allowedContentTypesItem);
        return this;
    }

    public ContentReferenceModelField removeAllowedContentTypesItem(ContentType allowedContentTypesItem) {
        if (allowedContentTypesItem != null && this.allowedContentTypes != null) {
            this.allowedContentTypes.remove((Object)allowedContentTypesItem);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentReferenceModelField contentReferenceModelField = (ContentReferenceModelField)o;
        return Objects.equals(this.placeholder, contentReferenceModelField.placeholder) && Objects.equals(this.showThumbnail, contentReferenceModelField.showThumbnail) && Objects.equals(this.root, contentReferenceModelField.root) && Objects.equals(this.defaultValue, contentReferenceModelField.defaultValue) && Objects.equals(this.imageWidth, contentReferenceModelField.imageWidth) && Objects.equals(this.imageHeight, contentReferenceModelField.imageHeight) && Objects.equals(this.fileSizeMin, contentReferenceModelField.fileSizeMin) && Objects.equals(this.fileSizeMax, contentReferenceModelField.fileSizeMax) && Objects.equals(this.allowedContentTypes, contentReferenceModelField.allowedContentTypes) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.placeholder, this.showThumbnail, this.root, this.defaultValue, this.imageWidth, this.imageHeight, this.fileSizeMin, this.fileSizeMax, this.allowedContentTypes, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentReferenceModelField {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    placeholder: ").append(this.toIndentedString(this.placeholder)).append("\n");
        sb.append("    showThumbnail: ").append(this.toIndentedString(this.showThumbnail)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.imageWidth)).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.imageHeight)).append("\n");
        sb.append("    fileSizeMin: ").append(this.toIndentedString(this.fileSizeMin)).append("\n");
        sb.append("    fileSizeMax: ").append(this.toIndentedString(this.fileSizeMax)).append("\n");
        sb.append("    allowedContentTypes: ").append(this.toIndentedString(this.allowedContentTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

