/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelIdentifier;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonTypeName(value="ContentFragmentReference")
public class ContentFragmentReference
extends BaseReference {
    @Valid
    private UUID id;
    @Valid
    private List<BaseReference> references;
    @Valid
    private ContentFragmentModelIdentifier model;
    @Valid
    private String description;
    @Valid
    private List<ContentFragmentField> fields = new ArrayList<ContentFragmentField>();
    @Valid
    private List<ContentFragmentVariation> variations = new ArrayList<ContentFragmentVariation>();
    @Valid
    private List<Tag> tags = new ArrayList<Tag>();

    public ContentFragmentReference id(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public ContentFragmentReference references(List<BaseReference> references) {
        this.references = references;
        return this;
    }

    @JsonProperty(value="references")
    public List<BaseReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<BaseReference> references) {
        this.references = references;
    }

    public ContentFragmentReference addReferencesItem(BaseReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<BaseReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    public ContentFragmentReference removeReferencesItem(BaseReference referencesItem) {
        if (referencesItem != null && this.references != null) {
            this.references.remove(referencesItem);
        }
        return this;
    }

    public ContentFragmentReference model(ContentFragmentModelIdentifier model) {
        this.model = model;
        return this;
    }

    @JsonProperty(value="model")
    public ContentFragmentModelIdentifier getModel() {
        return this.model;
    }

    @JsonProperty(value="model")
    public void setModel(ContentFragmentModelIdentifier model) {
        this.model = model;
    }

    public ContentFragmentReference description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ContentFragmentReference fields(List<ContentFragmentField> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty(value="fields")
    @NotNull
    public List<ContentFragmentField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<ContentFragmentField> fields) {
        this.fields = fields;
    }

    public ContentFragmentReference addFieldsItem(ContentFragmentField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ContentFragmentField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    public ContentFragmentReference removeFieldsItem(ContentFragmentField fieldsItem) {
        if (fieldsItem != null && this.fields != null) {
            this.fields.remove(fieldsItem);
        }
        return this;
    }

    public ContentFragmentReference variations(List<ContentFragmentVariation> variations) {
        this.variations = variations;
        return this;
    }

    @JsonProperty(value="variations")
    @NotNull
    public List<ContentFragmentVariation> getVariations() {
        return this.variations;
    }

    @JsonProperty(value="variations")
    public void setVariations(List<ContentFragmentVariation> variations) {
        this.variations = variations;
    }

    public ContentFragmentReference addVariationsItem(ContentFragmentVariation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<ContentFragmentVariation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    public ContentFragmentReference removeVariationsItem(ContentFragmentVariation variationsItem) {
        if (variationsItem != null && this.variations != null) {
            this.variations.remove(variationsItem);
        }
        return this;
    }

    public ContentFragmentReference tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="tags")
    @NotNull
    public List<Tag> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public ContentFragmentReference addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public ContentFragmentReference removeTagsItem(Tag tagsItem) {
        if (tagsItem != null && this.tags != null) {
            this.tags.remove(tagsItem);
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentFragmentReference contentFragmentReference = (ContentFragmentReference)o;
        return Objects.equals(this.id, contentFragmentReference.id) && Objects.equals(this.references, contentFragmentReference.references) && Objects.equals(this.model, contentFragmentReference.model) && Objects.equals(this.description, contentFragmentReference.description) && Objects.equals(this.fields, contentFragmentReference.fields) && Objects.equals(this.variations, contentFragmentReference.variations) && Objects.equals(this.tags, contentFragmentReference.tags) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.references, this.model, this.description, this.fields, this.variations, this.tags, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentFragmentReference {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

