/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="ContentFragmentPublishRequest")
public class ContentFragmentPublishRequest {
    @Valid
    private List<String> paths = new ArrayList<String>();
    @Valid
    private String agentId = "publish";
    @Valid
    private List<FilterReferencesByStatusEnum> filterReferencesByStatus = new ArrayList<FilterReferencesByStatusEnum>();
    @Valid
    private String workflowModelId = "/etc/workflow/models/scheduled_activation_with_references";
    @Valid
    private String workflowTitle;
    @Valid
    private Long scheduledTime;

    public ContentFragmentPublishRequest paths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    @JsonProperty(value="paths")
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getPaths() {
        return this.paths;
    }

    @JsonProperty(value="paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public ContentFragmentPublishRequest addPathsItem(String pathsItem) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(pathsItem);
        return this;
    }

    public ContentFragmentPublishRequest removePathsItem(String pathsItem) {
        if (pathsItem != null && this.paths != null) {
            this.paths.remove(pathsItem);
        }
        return this;
    }

    public ContentFragmentPublishRequest agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    @JsonProperty(value="agentId")
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public ContentFragmentPublishRequest filterReferencesByStatus(List<FilterReferencesByStatusEnum> filterReferencesByStatus) {
        this.filterReferencesByStatus = filterReferencesByStatus;
        return this;
    }

    @JsonProperty(value="filterReferencesByStatus")
    @NotNull
    @Size(max=3)
    public @NotNull @Size(max=3) List<FilterReferencesByStatusEnum> getFilterReferencesByStatus() {
        return this.filterReferencesByStatus;
    }

    @JsonProperty(value="filterReferencesByStatus")
    public void setFilterReferencesByStatus(List<FilterReferencesByStatusEnum> filterReferencesByStatus) {
        this.filterReferencesByStatus = filterReferencesByStatus;
    }

    public ContentFragmentPublishRequest addFilterReferencesByStatusItem(FilterReferencesByStatusEnum filterReferencesByStatusItem) {
        if (this.filterReferencesByStatus == null) {
            this.filterReferencesByStatus = new ArrayList<FilterReferencesByStatusEnum>();
        }
        this.filterReferencesByStatus.add(filterReferencesByStatusItem);
        return this;
    }

    public ContentFragmentPublishRequest removeFilterReferencesByStatusItem(FilterReferencesByStatusEnum filterReferencesByStatusItem) {
        if (filterReferencesByStatusItem != null && this.filterReferencesByStatus != null) {
            this.filterReferencesByStatus.remove((Object)filterReferencesByStatusItem);
        }
        return this;
    }

    public ContentFragmentPublishRequest workflowModelId(String workflowModelId) {
        this.workflowModelId = workflowModelId;
        return this;
    }

    @JsonProperty(value="workflowModelId")
    public String getWorkflowModelId() {
        return this.workflowModelId;
    }

    @JsonProperty(value="workflowModelId")
    public void setWorkflowModelId(String workflowModelId) {
        this.workflowModelId = workflowModelId;
    }

    public ContentFragmentPublishRequest workflowTitle(String workflowTitle) {
        this.workflowTitle = workflowTitle;
        return this;
    }

    @JsonProperty(value="workflowTitle")
    public String getWorkflowTitle() {
        return this.workflowTitle;
    }

    @JsonProperty(value="workflowTitle")
    public void setWorkflowTitle(String workflowTitle) {
        this.workflowTitle = workflowTitle;
    }

    public ContentFragmentPublishRequest scheduledTime(Long scheduledTime) {
        this.scheduledTime = scheduledTime;
        return this;
    }

    @JsonProperty(value="scheduledTime")
    public Long getScheduledTime() {
        return this.scheduledTime;
    }

    @JsonProperty(value="scheduledTime")
    public void setScheduledTime(Long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentFragmentPublishRequest contentFragmentPublishRequest = (ContentFragmentPublishRequest)o;
        return Objects.equals(this.paths, contentFragmentPublishRequest.paths) && Objects.equals(this.agentId, contentFragmentPublishRequest.agentId) && Objects.equals(this.filterReferencesByStatus, contentFragmentPublishRequest.filterReferencesByStatus) && Objects.equals(this.workflowModelId, contentFragmentPublishRequest.workflowModelId) && Objects.equals(this.workflowTitle, contentFragmentPublishRequest.workflowTitle) && Objects.equals(this.scheduledTime, contentFragmentPublishRequest.scheduledTime);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.agentId, this.filterReferencesByStatus, this.workflowModelId, this.workflowTitle, this.scheduledTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentFragmentPublishRequest {\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    filterReferencesByStatus: ").append(this.toIndentedString(this.filterReferencesByStatus)).append("\n");
        sb.append("    workflowModelId: ").append(this.toIndentedString(this.workflowModelId)).append("\n");
        sb.append("    workflowTitle: ").append(this.toIndentedString(this.workflowTitle)).append("\n");
        sb.append("    scheduledTime: ").append(this.toIndentedString(this.scheduledTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FilterReferencesByStatusEnum {
        DRAFT(String.valueOf("DRAFT")),
        UNPUBLISHED(String.valueOf("UNPUBLISHED")),
        MODIFIED(String.valueOf("MODIFIED"));

        private String value;

        private FilterReferencesByStatusEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static FilterReferencesByStatusEnum fromString(String s) {
            for (FilterReferencesByStatusEnum b : FilterReferencesByStatusEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static FilterReferencesByStatusEnum fromValue(String value) {
            for (FilterReferencesByStatusEnum b : FilterReferencesByStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

