/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonTypeName(value="ContentFragmentModel")
public class ContentFragmentModel {
    @Valid
    private String id;
    @Valid
    private String path;
    @Valid
    private String name;
    @Valid
    private String description;
    @Valid
    private AuthoringInfo created;
    @Valid
    private AuthoringInfo modified;
    @Valid
    private AuthoringInfo published;
    @Valid
    private Boolean locked;
    @Valid
    private StatusEnum status;
    @Valid
    private List<ContentFragmentModelField> fields = new ArrayList<ContentFragmentModelField>();
    @Valid
    private List<Tag> tags;

    public ContentFragmentModel id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public ContentFragmentModel path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public ContentFragmentModel name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public ContentFragmentModel description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ContentFragmentModel created(AuthoringInfo created) {
        this.created = created;
        return this;
    }

    @JsonProperty(value="created")
    @NotNull
    public AuthoringInfo getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(AuthoringInfo created) {
        this.created = created;
    }

    public ContentFragmentModel modified(AuthoringInfo modified) {
        this.modified = modified;
        return this;
    }

    @JsonProperty(value="modified")
    public AuthoringInfo getModified() {
        return this.modified;
    }

    @JsonProperty(value="modified")
    public void setModified(AuthoringInfo modified) {
        this.modified = modified;
    }

    public ContentFragmentModel published(AuthoringInfo published) {
        this.published = published;
        return this;
    }

    @JsonProperty(value="published")
    public AuthoringInfo getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    public void setPublished(AuthoringInfo published) {
        this.published = published;
    }

    public ContentFragmentModel locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @JsonProperty(value="locked")
    @NotNull
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public ContentFragmentModel status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ContentFragmentModel fields(List<ContentFragmentModelField> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty(value="fields")
    @NotNull
    public List<ContentFragmentModelField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<ContentFragmentModelField> fields) {
        this.fields = fields;
    }

    public ContentFragmentModel addFieldsItem(ContentFragmentModelField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ContentFragmentModelField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    public ContentFragmentModel removeFieldsItem(ContentFragmentModelField fieldsItem) {
        if (fieldsItem != null && this.fields != null) {
            this.fields.remove(fieldsItem);
        }
        return this;
    }

    public ContentFragmentModel tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="tags")
    public List<Tag> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public ContentFragmentModel addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public ContentFragmentModel removeTagsItem(Tag tagsItem) {
        if (tagsItem != null && this.tags != null) {
            this.tags.remove(tagsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentFragmentModel contentFragmentModel = (ContentFragmentModel)o;
        return Objects.equals(this.id, contentFragmentModel.id) && Objects.equals(this.path, contentFragmentModel.path) && Objects.equals(this.name, contentFragmentModel.name) && Objects.equals(this.description, contentFragmentModel.description) && Objects.equals(this.created, contentFragmentModel.created) && Objects.equals(this.modified, contentFragmentModel.modified) && Objects.equals(this.published, contentFragmentModel.published) && Objects.equals(this.locked, contentFragmentModel.locked) && Objects.equals((Object)this.status, (Object)contentFragmentModel.status) && Objects.equals(this.fields, contentFragmentModel.fields) && Objects.equals(this.tags, contentFragmentModel.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.path, this.name, this.description, this.created, this.modified, this.published, this.locked, this.status, this.fields, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentFragmentModel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ENABLED(String.valueOf("enabled")),
        DISABLED(String.valueOf("disabled")),
        DRAFT(String.valueOf("draft"));

        private String value;

        private StatusEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromString(String s) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

