/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelIdentifier;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.PreviewStatus;
import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.cq.dam.cfm.openapi.models.ValidationMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonTypeName(value="ContentFragment")
public class ContentFragment {
    @Valid
    private String path;
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private UUID id;
    @Valid
    private AuthoringInfo created;
    @Valid
    private AuthoringInfo modified;
    @Valid
    private AuthoringInfo published;
    @Valid
    private ResourceStatus status;
    @Valid
    private List<ContentFragmentField> fields = new ArrayList<ContentFragmentField>();
    @Valid
    private PreviewStatus previewStatus;
    @Valid
    private List<ContentFragmentVariation> variations;
    @Valid
    private List<Tag> tags = new ArrayList<Tag>();
    @Valid
    private List<BaseReference> references = new ArrayList<BaseReference>();
    @Valid
    private ContentFragmentModelIdentifier model;
    @Valid
    private List<ValidationMessage> validationStatus = new ArrayList<ValidationMessage>();
    @Valid
    private List<Tag> fieldTags = new ArrayList<Tag>();

    public ContentFragment path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public ContentFragment title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public ContentFragment description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ContentFragment id(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public ContentFragment created(AuthoringInfo created) {
        this.created = created;
        return this;
    }

    @JsonProperty(value="created")
    @NotNull
    public AuthoringInfo getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(AuthoringInfo created) {
        this.created = created;
    }

    public ContentFragment modified(AuthoringInfo modified) {
        this.modified = modified;
        return this;
    }

    @JsonProperty(value="modified")
    public AuthoringInfo getModified() {
        return this.modified;
    }

    @JsonProperty(value="modified")
    public void setModified(AuthoringInfo modified) {
        this.modified = modified;
    }

    public ContentFragment published(AuthoringInfo published) {
        this.published = published;
        return this;
    }

    @JsonProperty(value="published")
    public AuthoringInfo getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    public void setPublished(AuthoringInfo published) {
        this.published = published;
    }

    public ContentFragment status(ResourceStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @NotNull
    public ResourceStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(ResourceStatus status) {
        this.status = status;
    }

    public ContentFragment fields(List<ContentFragmentField> fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty(value="fields")
    @NotNull
    public List<ContentFragmentField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<ContentFragmentField> fields) {
        this.fields = fields;
    }

    public ContentFragment addFieldsItem(ContentFragmentField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<ContentFragmentField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    public ContentFragment removeFieldsItem(ContentFragmentField fieldsItem) {
        if (fieldsItem != null && this.fields != null) {
            this.fields.remove(fieldsItem);
        }
        return this;
    }

    public ContentFragment previewStatus(PreviewStatus previewStatus) {
        this.previewStatus = previewStatus;
        return this;
    }

    @JsonProperty(value="previewStatus")
    public PreviewStatus getPreviewStatus() {
        return this.previewStatus;
    }

    @JsonProperty(value="previewStatus")
    public void setPreviewStatus(PreviewStatus previewStatus) {
        this.previewStatus = previewStatus;
    }

    public ContentFragment variations(List<ContentFragmentVariation> variations) {
        this.variations = variations;
        return this;
    }

    @JsonProperty(value="variations")
    public List<ContentFragmentVariation> getVariations() {
        return this.variations;
    }

    @JsonProperty(value="variations")
    public void setVariations(List<ContentFragmentVariation> variations) {
        this.variations = variations;
    }

    public ContentFragment addVariationsItem(ContentFragmentVariation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<ContentFragmentVariation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    public ContentFragment removeVariationsItem(ContentFragmentVariation variationsItem) {
        if (variationsItem != null && this.variations != null) {
            this.variations.remove(variationsItem);
        }
        return this;
    }

    public ContentFragment tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="tags")
    @NotNull
    public List<Tag> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public ContentFragment addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public ContentFragment removeTagsItem(Tag tagsItem) {
        if (tagsItem != null && this.tags != null) {
            this.tags.remove(tagsItem);
        }
        return this;
    }

    public ContentFragment references(List<BaseReference> references) {
        this.references = references;
        return this;
    }

    @JsonProperty(value="references")
    public List<BaseReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<BaseReference> references) {
        this.references = references;
    }

    public ContentFragment addReferencesItem(BaseReference referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<BaseReference>();
        }
        this.references.add(referencesItem);
        return this;
    }

    public ContentFragment removeReferencesItem(BaseReference referencesItem) {
        if (referencesItem != null && this.references != null) {
            this.references.remove(referencesItem);
        }
        return this;
    }

    public ContentFragment model(ContentFragmentModelIdentifier model) {
        this.model = model;
        return this;
    }

    @JsonProperty(value="model")
    @NotNull
    public ContentFragmentModelIdentifier getModel() {
        return this.model;
    }

    @JsonProperty(value="model")
    public void setModel(ContentFragmentModelIdentifier model) {
        this.model = model;
    }

    public ContentFragment validationStatus(List<ValidationMessage> validationStatus) {
        this.validationStatus = validationStatus;
        return this;
    }

    @JsonProperty(value="validationStatus")
    @NotNull
    public List<ValidationMessage> getValidationStatus() {
        return this.validationStatus;
    }

    @JsonProperty(value="validationStatus")
    public void setValidationStatus(List<ValidationMessage> validationStatus) {
        this.validationStatus = validationStatus;
    }

    public ContentFragment addValidationStatusItem(ValidationMessage validationStatusItem) {
        if (this.validationStatus == null) {
            this.validationStatus = new ArrayList<ValidationMessage>();
        }
        this.validationStatus.add(validationStatusItem);
        return this;
    }

    public ContentFragment removeValidationStatusItem(ValidationMessage validationStatusItem) {
        if (validationStatusItem != null && this.validationStatus != null) {
            this.validationStatus.remove(validationStatusItem);
        }
        return this;
    }

    public ContentFragment fieldTags(List<Tag> fieldTags) {
        this.fieldTags = fieldTags;
        return this;
    }

    @JsonProperty(value="fieldTags")
    public List<Tag> getFieldTags() {
        return this.fieldTags;
    }

    @JsonProperty(value="fieldTags")
    public void setFieldTags(List<Tag> fieldTags) {
        this.fieldTags = fieldTags;
    }

    public ContentFragment addFieldTagsItem(Tag fieldTagsItem) {
        if (this.fieldTags == null) {
            this.fieldTags = new ArrayList<Tag>();
        }
        this.fieldTags.add(fieldTagsItem);
        return this;
    }

    public ContentFragment removeFieldTagsItem(Tag fieldTagsItem) {
        if (fieldTagsItem != null && this.fieldTags != null) {
            this.fieldTags.remove(fieldTagsItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentFragment contentFragment = (ContentFragment)o;
        return Objects.equals(this.path, contentFragment.path) && Objects.equals(this.title, contentFragment.title) && Objects.equals(this.description, contentFragment.description) && Objects.equals(this.id, contentFragment.id) && Objects.equals(this.created, contentFragment.created) && Objects.equals(this.modified, contentFragment.modified) && Objects.equals(this.published, contentFragment.published) && Objects.equals((Object)this.status, (Object)contentFragment.status) && Objects.equals(this.fields, contentFragment.fields) && Objects.equals((Object)this.previewStatus, (Object)contentFragment.previewStatus) && Objects.equals(this.variations, contentFragment.variations) && Objects.equals(this.tags, contentFragment.tags) && Objects.equals(this.references, contentFragment.references) && Objects.equals(this.model, contentFragment.model) && Objects.equals(this.validationStatus, contentFragment.validationStatus) && Objects.equals(this.fieldTags, contentFragment.fieldTags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.title, this.description, this.id, this.created, this.modified, this.published, this.status, this.fields, this.previewStatus, this.variations, this.tags, this.references, this.model, this.validationStatus, this.fieldTags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentFragment {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    previewStatus: ").append(this.toIndentedString((Object)this.previewStatus)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    validationStatus: ").append(this.toIndentedString(this.validationStatus)).append("\n");
        sb.append("    fieldTags: ").append(this.toIndentedString(this.fieldTags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

