/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.AssetReference;
import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentReference;
import com.adobe.cq.dam.cfm.openapi.models.ExperienceFragmentReference;
import com.adobe.cq.dam.cfm.openapi.models.PageReference;
import com.adobe.cq.dam.cfm.openapi.models.PreviewStatus;
import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AssetReference.class, name="asset"), @JsonSubTypes.Type(value=ContentFragmentReference.class, name="content-fragment"), @JsonSubTypes.Type(value=ExperienceFragmentReference.class, name="experience-fragment"), @JsonSubTypes.Type(value=PageReference.class, name="page")})
@JsonTypeName(value="BaseReference")
public class BaseReference {
    @Valid
    private String name;
    @Valid
    private String fieldName;
    @Valid
    private TypeEnum type;
    @Valid
    private String title;
    @Valid
    private String path;
    @Valid
    private AuthoringInfo created;
    @Valid
    private AuthoringInfo modified;
    @Valid
    private AuthoringInfo published;
    @Valid
    private ResourceStatus status;
    @Valid
    private PreviewStatus previewStatus;

    public BaseReference name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public BaseReference fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="fieldName")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public BaseReference type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BaseReference title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public BaseReference path(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="path")
    @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$")
    public @Pattern(regexp="^(?:(?!\\*|\\[|\\]|\\||\\\\|\\|).)*$") String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public BaseReference created(AuthoringInfo created) {
        this.created = created;
        return this;
    }

    @JsonProperty(value="created")
    public AuthoringInfo getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    public void setCreated(AuthoringInfo created) {
        this.created = created;
    }

    public BaseReference modified(AuthoringInfo modified) {
        this.modified = modified;
        return this;
    }

    @JsonProperty(value="modified")
    public AuthoringInfo getModified() {
        return this.modified;
    }

    @JsonProperty(value="modified")
    public void setModified(AuthoringInfo modified) {
        this.modified = modified;
    }

    public BaseReference published(AuthoringInfo published) {
        this.published = published;
        return this;
    }

    @JsonProperty(value="published")
    public AuthoringInfo getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    public void setPublished(AuthoringInfo published) {
        this.published = published;
    }

    public BaseReference status(ResourceStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    public ResourceStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(ResourceStatus status) {
        this.status = status;
    }

    public BaseReference previewStatus(PreviewStatus previewStatus) {
        this.previewStatus = previewStatus;
        return this;
    }

    @JsonProperty(value="previewStatus")
    public PreviewStatus getPreviewStatus() {
        return this.previewStatus;
    }

    @JsonProperty(value="previewStatus")
    public void setPreviewStatus(PreviewStatus previewStatus) {
        this.previewStatus = previewStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReference baseReference = (BaseReference)o;
        return Objects.equals(this.name, baseReference.name) && Objects.equals(this.fieldName, baseReference.fieldName) && Objects.equals((Object)this.type, (Object)baseReference.type) && Objects.equals(this.title, baseReference.title) && Objects.equals(this.path, baseReference.path) && Objects.equals(this.created, baseReference.created) && Objects.equals(this.modified, baseReference.modified) && Objects.equals(this.published, baseReference.published) && Objects.equals((Object)this.status, (Object)baseReference.status) && Objects.equals((Object)this.previewStatus, (Object)baseReference.previewStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.fieldName, this.type, this.title, this.path, this.created, this.modified, this.published, this.status, this.previewStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReference {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    previewStatus: ").append(this.toIndentedString((Object)this.previewStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CONTENT_FRAGMENT(String.valueOf("content-fragment")),
        EXPERIENCE_FRAGMENT(String.valueOf("experience-fragment")),
        ASSET(String.valueOf("asset")),
        PAGE(String.valueOf("page"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromString(String s) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

