/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.openapi.models;

import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

@JsonTypeName(value="AssetReference")
public class AssetReference
extends BaseReference {
    @Valid
    private String assetId;
    @Valid
    private Long repoColonSize;
    @Valid
    private String dcColonFormat;
    @Valid
    private Long tiffColonImageWidth;
    @Valid
    private Long tiffColonImageHeight;

    public AssetReference assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @JsonProperty(value="assetId")
    @Pattern(regexp="^urn:[a-z0-9][a-z0-9-]{0,31}:[a-z0-9()+,-.:=@;$_!*'%/?#]+$")
    public @Pattern(regexp="^urn:[a-z0-9][a-z0-9-]{0,31}:[a-z0-9()+,-.:=@;$_!*'%/?#]+$") String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public AssetReference repoColonSize(Long repoColonSize) {
        this.repoColonSize = repoColonSize;
        return this;
    }

    @JsonProperty(value="repo:size")
    public Long getRepoColonSize() {
        return this.repoColonSize;
    }

    @JsonProperty(value="repo:size")
    public void setRepoColonSize(Long repoColonSize) {
        this.repoColonSize = repoColonSize;
    }

    public AssetReference dcColonFormat(String dcColonFormat) {
        this.dcColonFormat = dcColonFormat;
        return this;
    }

    @JsonProperty(value="dc:format")
    public String getDcColonFormat() {
        return this.dcColonFormat;
    }

    @JsonProperty(value="dc:format")
    public void setDcColonFormat(String dcColonFormat) {
        this.dcColonFormat = dcColonFormat;
    }

    public AssetReference tiffColonImageWidth(Long tiffColonImageWidth) {
        this.tiffColonImageWidth = tiffColonImageWidth;
        return this;
    }

    @JsonProperty(value="tiff:ImageWidth")
    public Long getTiffColonImageWidth() {
        return this.tiffColonImageWidth;
    }

    @JsonProperty(value="tiff:ImageWidth")
    public void setTiffColonImageWidth(Long tiffColonImageWidth) {
        this.tiffColonImageWidth = tiffColonImageWidth;
    }

    public AssetReference tiffColonImageHeight(Long tiffColonImageHeight) {
        this.tiffColonImageHeight = tiffColonImageHeight;
        return this;
    }

    @JsonProperty(value="tiff:ImageHeight")
    public Long getTiffColonImageHeight() {
        return this.tiffColonImageHeight;
    }

    @JsonProperty(value="tiff:ImageHeight")
    public void setTiffColonImageHeight(Long tiffColonImageHeight) {
        this.tiffColonImageHeight = tiffColonImageHeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReference assetReference = (AssetReference)o;
        return Objects.equals(this.assetId, assetReference.assetId) && Objects.equals(this.repoColonSize, assetReference.repoColonSize) && Objects.equals(this.dcColonFormat, assetReference.dcColonFormat) && Objects.equals(this.tiffColonImageWidth, assetReference.tiffColonImageWidth) && Objects.equals(this.tiffColonImageHeight, assetReference.tiffColonImageHeight) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assetId, this.repoColonSize, this.dcColonFormat, this.tiffColonImageWidth, this.tiffColonImageHeight, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetReference {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    repoColonSize: ").append(this.toIndentedString(this.repoColonSize)).append("\n");
        sb.append("    dcColonFormat: ").append(this.toIndentedString(this.dcColonFormat)).append("\n");
        sb.append("    tiffColonImageWidth: ").append(this.toIndentedString(this.tiffColonImageWidth)).append("\n");
        sb.append("    tiffColonImageHeight: ").append(this.toIndentedString(this.tiffColonImageHeight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

