/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.impl.servlets.validators.RequiredFragmentReference;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceModelField;
import com.adobe.granite.toggle.api.ToggleRouter;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.List;

public class RequiredFragmentReferenceValidator
implements ConstraintValidator<RequiredFragmentReference, FragmentReferenceModelField> {
    private ToggleRouter toggleRouter;

    public RequiredFragmentReferenceValidator(ToggleRouter toggleRouter) {
        this.toggleRouter = toggleRouter;
    }

    public boolean isValid(FragmentReferenceModelField field, ConstraintValidatorContext context) {
        List<String> items = field.getItems();
        List<String> tags = field.getTags();
        String message = "Allowed content fragment models are not specified.";
        boolean isValid = this.isValid(items);
        if (this.toggleRouter.isEnabled("FT_SITES-11210")) {
            message = "Allowed content fragment models need to be specified either by path or by tag.";
            boolean bl = isValid = this.isValid(items) || this.isValid(tags);
        }
        if (!isValid) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
        }
        return isValid;
    }

    private boolean isValid(List<String> list) {
        return list != null && !list.isEmpty();
    }
}

