/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.impl.servlets.validators.ToggleRouterAwareConstraintValidatorFactory;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.ValidationMessage;
import com.adobe.granite.toggle.api.ToggleRouter;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.bootstrap.ProviderSpecificBootstrap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestValidator.class})
public class RequestValidator {
    private static final Logger log = LoggerFactory.getLogger(RequestValidator.class);
    @Reference
    public ToggleRouter toggleRouter;
    private static final List<DataType> ALWAYS_SINGLE_FIELDS = List.of(DataType.BOOLEAN, DataType.DATE, DataType.DATE_TIME, DataType.TIME, DataType.JSON);
    private static final List<DataType> ALWAYS_MULTIPLE_FIELDS = List.of();
    private ProviderSpecificBootstrap<HibernateValidatorConfiguration> providerSpecificBootstrap;
    private ValidatorFactory validatorFactory;
    private Validator validator;

    @Activate
    public void activate() {
        log.info("Activating request validator");
        this.providerSpecificBootstrap = Validation.byProvider(HibernateValidator.class).providerResolver(() -> List.of(new HibernateValidator()));
        HibernateValidatorConfiguration configuration = this.buildConfiguration();
        this.validatorFactory = configuration.buildValidatorFactory();
        this.validator = this.validatorFactory.getValidator();
    }

    @Deactivate
    public void deactivate() {
        log.info("Deactivating request validator");
        this.validatorFactory.close();
    }

    HibernateValidatorConfiguration buildConfiguration() {
        return (HibernateValidatorConfiguration)((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)this.providerSpecificBootstrap.configure()).constraintValidatorFactory((ConstraintValidatorFactory)new ToggleRouterAwareConstraintValidatorFactory(this.toggleRouter))).messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator());
    }

    public String buildValidationMessage(List<String> messages) {
        return messages.isEmpty() ? "" : String.join((CharSequence)", ", messages);
    }

    public ValidationMessage convert(ConstraintViolation<?> violation) {
        ValidationMessage message = new ValidationMessage();
        message.setMessage(violation.getMessage());
        message.setProperty(violation.getPropertyPath().toString());
        return message;
    }

    public <T> List<ValidationMessage> getRawValidationMessages(T obj) {
        Set violations = this.validator.validate(obj, new Class[0]);
        return violations.stream().map(this::convert).collect(Collectors.toList());
    }

    public <T> List<String> getValidationMessages(T obj) {
        return this.getRawValidationMessages(obj).stream().map(validationMessage -> {
            if (StringUtils.isBlank((CharSequence)validationMessage.getProperty())) {
                return validationMessage.getMessage();
            }
            return validationMessage.getProperty() + " " + validationMessage.getMessage();
        }).collect(Collectors.toUnmodifiableList());
    }

    public Optional<String> validateModelFields(List<ContentFragmentModelField> modelFields) {
        String multipleFieldNames;
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        String singleFieldNames = modelFields.stream().filter(field -> Boolean.TRUE.equals(field.getMultiple()) && ALWAYS_SINGLE_FIELDS.contains((Object)field.getType())).map(ContentFragmentModelField::getName).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)singleFieldNames)) {
            String message = "multiple fields of type " + ALWAYS_SINGLE_FIELDS.stream().map(DataType::toString).collect(Collectors.joining(", ")) + " are not supported: " + singleFieldNames;
            messages.add((CallSite)((Object)message));
        }
        if (StringUtils.isNotBlank((CharSequence)(multipleFieldNames = modelFields.stream().filter(field -> !Boolean.TRUE.equals(field.getMultiple()) && ALWAYS_MULTIPLE_FIELDS.contains((Object)field.getType())).map(ContentFragmentModelField::getName).collect(Collectors.joining(", "))))) {
            String message = "single fields of type " + ALWAYS_MULTIPLE_FIELDS.stream().map(DataType::toString).collect(Collectors.joining(", ")) + " are not supported: " + multipleFieldNames;
            messages.add((CallSite)((Object)message));
        }
        if (messages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"\n", messages));
    }
}

