/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.impl.servlets.validators.MinItemsMaxItems;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class MinItemsMaxItemsValidator
implements ConstraintValidator<MinItemsMaxItems, ContentFragmentModelField> {
    public static final String MIN_ITEMS = "minItems";
    public static final String MAX_ITEMS = "maxItems";

    public boolean isValid(ContentFragmentModelField field, ConstraintValidatorContext context) {
        Integer minItems = field.getMinItems();
        Integer maxItems = field.getMaxItems();
        Boolean multiple = field.getMultiple();
        Boolean required = field.getRequired();
        if (minItems != null && maxItems != null) {
            if (Boolean.TRUE.equals(multiple)) {
                if (Boolean.TRUE.equals(required)) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("must be at least 1 when required is true and multiple is true").addPropertyNode(MIN_ITEMS).addConstraintViolation();
                    context.buildConstraintViolationWithTemplate("must be greater than or equal to minItems when required is true and multiple is true").addPropertyNode(MAX_ITEMS).addConstraintViolation();
                    return minItems >= 1 && minItems <= maxItems;
                }
            } else {
                if (Boolean.TRUE.equals(required)) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate("must be equal to 1 when required is true and multiple is false").addPropertyNode(MIN_ITEMS).addConstraintViolation();
                    context.buildConstraintViolationWithTemplate("must be equal to 1 when required is true and multiple is false").addPropertyNode(MAX_ITEMS).addConstraintViolation();
                    return minItems == 1 && maxItems == 1;
                }
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("must be equal to 0 when required is false and multiple is false").addPropertyNode(MIN_ITEMS).addConstraintViolation();
                context.buildConstraintViolationWithTemplate("must be equal to 1 when required is false and multiple is false").addPropertyNode(MAX_ITEMS).addConstraintViolation();
                return minItems == 0 && maxItems == 1;
            }
            return minItems <= maxItems;
        }
        if (minItems != null && Boolean.FALSE.equals(multiple)) {
            if (Boolean.TRUE.equals(required)) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("must be equal to 1 when required is true and multiple is false").addPropertyNode(MIN_ITEMS).addConstraintViolation();
                return minItems == 1;
            }
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("must be at most 1 when required is false and multiple is false").addPropertyNode(MIN_ITEMS).addConstraintViolation();
            return minItems <= 1;
        }
        if (maxItems != null && Boolean.FALSE.equals(multiple)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("must be equal to 1 when multiple is false").addPropertyNode(MAX_ITEMS).addConstraintViolation();
            return maxItems == 1;
        }
        return true;
    }
}

