/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.impl.servlets.validators.DefaultValueProvider;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FragmentValidatorContext {
    private static final String FRAGMENT_FIELD_NOT_DEFINED_IN_MODEL = "Fragment field with name %s, type %s and multiple %b is not defined in the model";
    private static final String FRAGMENT_FIELD_TOO_MANY_VALUES = "Fragment field with name %s, type %s and multiple %b has too many values: %d";
    private final Map<String, ContentFragmentField> fragmentFields;
    private final Map<String, ContentFragmentModelField> modelFields;

    public FragmentValidatorContext(List<ContentFragmentField> fragmentFields, List<ContentFragmentModelField> modelFields) {
        this.modelFields = modelFields.stream().collect(Collectors.toMap(ContentFragmentModelField::getName, Function.identity()));
        this.fragmentFields = fragmentFields == null ? new HashMap<String, ContentFragmentField>() : fragmentFields.stream().collect(Collectors.toMap(ContentFragmentField::getName, Function.identity()));
    }

    public void addMultiple() {
        for (ContentFragmentModelField modelField : this.modelFields.values()) {
            ContentFragmentField fragmentField = this.fragmentFields.get(modelField.getName());
            if (fragmentField == null) continue;
            fragmentField.setMultiple(modelField.getMultiple());
        }
    }

    public void addDefaultValues(DefaultValueProvider defaultValueProvider) {
        for (ContentFragmentModelField modelField : this.modelFields.values()) {
            ContentFragmentField fragmentField = this.fragmentFields.get(modelField.getName());
            if (fragmentField != null) continue;
            this.fragmentFields.put(modelField.getName(), defaultValueProvider.getDefault(modelField));
        }
    }

    public List<ValidationMessage> validateFieldNotDefinedInModel() {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        for (ContentFragmentField fragmentField : this.fragmentFields.values()) {
            int size;
            ContentFragmentModelField modelField = this.modelFields.get(fragmentField.getName());
            if (modelField == null || modelField.getType() != fragmentField.getType() || !FragmentValidatorContext.areEqual(modelField.getMultiple(), fragmentField.getMultiple())) {
                validationMessages.add(new ValidationMessage().property("fields." + fragmentField.getName()).message(String.format(FRAGMENT_FIELD_NOT_DEFINED_IN_MODEL, new Object[]{fragmentField.getName(), fragmentField.getType(), Boolean.TRUE.equals(fragmentField.getMultiple())})));
                continue;
            }
            boolean multiple = Boolean.TRUE.equals(modelField.getMultiple());
            int n = size = fragmentField.getValues() == null ? 0 : fragmentField.getValues().size();
            if (multiple || size <= 1) continue;
            validationMessages.add(new ValidationMessage().property("fields." + fragmentField.getName()).message(String.format(FRAGMENT_FIELD_TOO_MANY_VALUES, new Object[]{fragmentField.getName(), fragmentField.getType(), Boolean.TRUE.equals(fragmentField.getMultiple()), size})));
        }
        validationMessages.forEach(validationMessage -> this.fragmentFields.remove(validationMessage.getProperty()));
        return validationMessages;
    }

    private static boolean areEqual(Boolean bool1, Boolean bool2) {
        boolean value1 = bool1 != null && bool1 != false;
        boolean value2 = bool2 != null && bool2 != false;
        return value1 == value2;
    }

    public Map<String, ContentFragmentField> getFragmentFields() {
        return this.fragmentFields;
    }

    public Map<String, ContentFragmentModelField> getModelFields() {
        return this.modelFields;
    }
}

