/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.headless.backend.Metrics;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.servlets.validators.DefaultValueProvider;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentFieldDynamicValidator;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidationResult;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidatorContext;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.CreateContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.ValidationMessage;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.ResourceResolver;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FragmentValidator.class})
public class FragmentValidator {
    private static final Logger log = LoggerFactory.getLogger(FragmentValidator.class);
    private final FragmentFieldDynamicValidator dynamicValidator = new FragmentFieldDynamicValidator();
    private final DefaultValueProvider defaultValueProvider = new DefaultValueProvider();
    private static final String METRIC_LIST_FRAGMENTS = "fragments";
    private static final String METRIC_LIST_VARIATIONS = "variations";
    private static final String METRIC_NAME = "validate";
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private ContentFragmentModelManager modelManager;
    @Reference
    private Metrics metrics;

    public FragmentValidationResult validate(CreateContentFragment contentFragmentRequest, ResourceResolver resourceResolver) {
        long start = System.currentTimeMillis();
        List<ValidationMessage> validationMessages = this.requestValidator.getRawValidationMessages(contentFragmentRequest);
        if (!validationMessages.isEmpty()) {
            this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
            return FragmentValidationResult.invalid(validationMessages);
        }
        ContentFragmentModel model = this.modelManager.getModel(resourceResolver, contentFragmentRequest.getModelId());
        if (model == null) {
            this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
            return FragmentValidationResult.invalid(List.of(new ValidationMessage().property("modelId").message("modelId does not exist in the repository")));
        }
        FragmentValidationResult result = this.validate(contentFragmentRequest.getFields(), model.getFields(), true);
        this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
        return result;
    }

    public FragmentValidationResult validate(ContentFragmentVariation variation, List<ContentFragmentModelField> modelFields) {
        long start = System.currentTimeMillis();
        List<ValidationMessage> validationMessages = this.requestValidator.getRawValidationMessages(variation);
        if (!validationMessages.isEmpty()) {
            this.metrics.addMetricTimer(METRIC_LIST_VARIATIONS, METRIC_NAME, start);
            return FragmentValidationResult.invalid(validationMessages);
        }
        FragmentValidationResult result = this.validate(variation.getFields(), modelFields, false);
        this.metrics.addMetricTimer(METRIC_LIST_VARIATIONS, METRIC_NAME, start);
        return result;
    }

    public FragmentValidationResult validate(ContentFragment contentFragment, ResourceResolver resourceResolver) {
        long start = System.currentTimeMillis();
        List<ValidationMessage> validationMessages = this.requestValidator.getRawValidationMessages(contentFragment);
        if (!validationMessages.isEmpty()) {
            this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
            return FragmentValidationResult.invalid(validationMessages);
        }
        ContentFragmentModel model = this.modelManager.getModel(resourceResolver, contentFragment.getModel().getId());
        if (model == null) {
            this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
            return FragmentValidationResult.invalid(List.of(new ValidationMessage().property("modelId").message("modelId does not exist in the repository")));
        }
        FragmentValidationResult result = this.validate(contentFragment.getFields(), model.getFields(), false);
        this.metrics.addMetricTimer(METRIC_LIST_FRAGMENTS, METRIC_NAME, start);
        return result;
    }

    private FragmentValidationResult validate(List<ContentFragmentField> fragmentFields, List<ContentFragmentModelField> modelFields, boolean addDataFromModel) {
        FragmentValidatorContext context = new FragmentValidatorContext(fragmentFields, modelFields);
        if (addDataFromModel) {
            context.addMultiple();
        }
        FragmentValidationResult validationResult = new FragmentValidationResult();
        List<ValidationMessage> validationMessages = context.validateFieldNotDefinedInModel();
        if (!validationMessages.isEmpty()) {
            validationResult.setPartiallyValid(false);
            validationResult.setFullyValid(false);
            validationResult.addValidationMessages(validationMessages);
        }
        if (addDataFromModel) {
            context.addDefaultValues(this.defaultValueProvider);
        }
        if (!(validationMessages = this.validateConstraints(context)).isEmpty()) {
            validationResult.setFullyValid(false);
            validationResult.addValidationMessages(validationMessages);
        }
        return validationResult;
    }

    private List<ValidationMessage> validateConstraints(FragmentValidatorContext context) {
        Map<String, ContentFragmentField> fragmentFields = context.getFragmentFields();
        Map<String, ContentFragmentModelField> modelFields = context.getModelFields();
        return modelFields.values().stream().flatMap(modelField -> {
            HibernateValidatorConfiguration configuration = this.requestValidator.buildConfiguration();
            ConstraintMapping constraintMapping = configuration.createConstraintMapping();
            ContentFragmentField fragmentField = (ContentFragmentField)fragmentFields.get(modelField.getName());
            this.dynamicValidator.addFieldConstraints(constraintMapping, fragmentField, (ContentFragmentModelField)modelField);
            try (ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)configuration.addMapping(constraintMapping)).buildValidatorFactory();){
                Validator validator = validatorFactory.getValidator();
                Stream<Pair> stream = validator.validate((Object)fragmentField, new Class[0]).stream().map(violation -> Pair.of((Object)modelField.getName(), (Object)violation));
                return stream;
            }
        }).map(pair -> {
            String fieldName = (String)pair.getLeft();
            ConstraintViolation violation = (ConstraintViolation)pair.getRight();
            ValidationMessage validationMessage = new ValidationMessage().message(violation.getMessage());
            if (!StringUtils.isBlank((CharSequence)violation.getPropertyPath().toString())) {
                validationMessage.property("fields." + fieldName + "." + violation.getPropertyPath().toString());
            }
            return validationMessage;
        }).collect(Collectors.toUnmodifiableList());
    }

    FragmentValidationResult validate(List<ContentFragmentField> fragmentFields, List<ContentFragmentModelField> modelFields) {
        return this.validate(fragmentFields, modelFields, true);
    }

    void setRequestValidator(RequestValidator requestValidator) {
        this.requestValidator = requestValidator;
    }
}

