/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.impl.servlets.validators.AllowedValuesDef;
import com.adobe.cq.dam.cfm.impl.servlets.validators.HtmlDef;
import com.adobe.cq.dam.cfm.openapi.models.BooleanFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.BooleanModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceModelField;
import com.adobe.cq.dam.cfm.openapi.models.DateFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateModelField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeModelField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationModelField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationModelFieldAllOfValues;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceModelField;
import com.adobe.cq.dam.cfm.openapi.models.JsonFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.JsonModelField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongTextModelField;
import com.adobe.cq.dam.cfm.openapi.models.MimeType;
import com.adobe.cq.dam.cfm.openapi.models.TagFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TagModelField;
import com.adobe.cq.dam.cfm.openapi.models.TextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextModelField;
import com.adobe.cq.dam.cfm.openapi.models.TimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TimeModelField;
import java.util.stream.Collectors;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.context.ContainerElementConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.cfg.defs.DecimalMaxDef;
import org.hibernate.validator.cfg.defs.DecimalMinDef;
import org.hibernate.validator.cfg.defs.EmailDef;
import org.hibernate.validator.cfg.defs.MaxDef;
import org.hibernate.validator.cfg.defs.MinDef;
import org.hibernate.validator.cfg.defs.NotNullDef;
import org.hibernate.validator.cfg.defs.PatternDef;
import org.hibernate.validator.cfg.defs.SizeDef;
import org.hibernate.validator.cfg.defs.URLDef;

class FragmentFieldDynamicValidator {
    private static final String VALUES_PROPERTY = "values";

    FragmentFieldDynamicValidator() {
    }

    public void addFieldConstraints(ConstraintMapping constraintMapping, ContentFragmentField fragmentField, ContentFragmentModelField modelField) {
        switch (modelField.getType()) {
            case TEXT: {
                this.addConstraints(constraintMapping, (TextModelField)modelField, (TextFragmentField)fragmentField);
                break;
            }
            case LONG_TEXT: {
                this.addConstraints(constraintMapping, (LongTextModelField)modelField, (LongTextFragmentField)fragmentField);
                break;
            }
            case NUMBER: {
                this.addConstraints(constraintMapping, (LongNumberModelField)modelField, (LongNumberFragmentField)fragmentField);
                break;
            }
            case FLOAT_NUMBER: {
                this.addConstraints(constraintMapping, (DoubleNumberModelField)modelField, (DoubleNumberFragmentField)fragmentField);
                break;
            }
            case ENUMERATION: {
                this.addConstraints(constraintMapping, (EnumerationModelField)modelField, (EnumerationFragmentField)fragmentField);
                break;
            }
            case CONTENT_REFERENCE: {
                this.addConstraints(constraintMapping, (ContentReferenceModelField)modelField, (ContentReferenceFragmentField)fragmentField);
                break;
            }
            case CONTENT_FRAGMENT: {
                this.addConstraints(constraintMapping, (FragmentReferenceModelField)modelField, (FragmentReferenceFragmentField)fragmentField);
                break;
            }
            case TAG: {
                this.addConstraints(constraintMapping, (TagModelField)modelField, (TagFragmentField)fragmentField);
                break;
            }
            case BOOLEAN: {
                this.addConstraints(constraintMapping, (BooleanModelField)modelField, (BooleanFragmentField)fragmentField);
                break;
            }
            case DATE: {
                this.addConstraints(constraintMapping, (DateModelField)modelField, (DateFragmentField)fragmentField);
                break;
            }
            case TIME: {
                this.addConstraints(constraintMapping, (TimeModelField)modelField, (TimeFragmentField)fragmentField);
                break;
            }
            case DATE_TIME: {
                this.addConstraints(constraintMapping, (DateTimeModelField)modelField, (DateTimeFragmentField)fragmentField);
                break;
            }
            case JSON: {
                this.addConstraints(constraintMapping, (JsonModelField)modelField, (JsonFragmentField)fragmentField);
            }
        }
    }

    private PropertyConstraintMappingContext buildValuesPropertyConstraintMappingContext(ConstraintMapping constraintMapping, ContentFragmentModelField modelField, Class<? extends ContentFragmentField> clazz) {
        boolean multiple = Boolean.TRUE.equals(modelField.getMultiple());
        boolean required = Boolean.TRUE.equals(modelField.getRequired());
        PropertyConstraintMappingContext propertyConstraintMappingContext = constraintMapping.type(clazz).field(VALUES_PROPERTY);
        Integer minItems = null;
        Integer maxItems = null;
        if (modelField.getMinItems() != null && modelField.getMaxItems() != null) {
            minItems = modelField.getMinItems();
            maxItems = modelField.getMaxItems();
        } else if (modelField.getMinItems() != null) {
            minItems = modelField.getMinItems();
        } else if (modelField.getMaxItems() != null) {
            maxItems = modelField.getMaxItems();
        }
        if (multiple && required) {
            if (minItems == null || minItems < 1) {
                minItems = 1;
            }
        } else if (!multiple) {
            if (required) {
                if (minItems == null || minItems < 1) {
                    minItems = 1;
                }
                if (maxItems == null || maxItems > 1) {
                    maxItems = 1;
                }
            } else if (maxItems == null || maxItems > 1) {
                maxItems = 1;
            }
        }
        if (minItems != null && maxItems != null) {
            propertyConstraintMappingContext.constraint((ConstraintDef)new NotNullDef());
            propertyConstraintMappingContext.constraint((ConstraintDef)new SizeDef().min(minItems.intValue()).max(maxItems.intValue()));
        } else if (minItems != null) {
            propertyConstraintMappingContext.constraint((ConstraintDef)new NotNullDef());
            propertyConstraintMappingContext.constraint((ConstraintDef)new SizeDef().min(minItems.intValue()));
        } else if (maxItems != null) {
            propertyConstraintMappingContext.constraint((ConstraintDef)new SizeDef().max(maxItems.intValue()));
        }
        return propertyConstraintMappingContext;
    }

    private void addConstraints(ConstraintMapping constraintMapping, TextModelField modelField, TextFragmentField fragmentField) {
        PropertyConstraintMappingContext propertyConstraintMappingContext = this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
        ContainerElementConstraintMappingContext mappingContext = propertyConstraintMappingContext.containerElementType(0, new int[0]);
        mappingContext.constraint((ConstraintDef)new SizeDef().max(modelField.getMaxLength() == null ? 255 : modelField.getMaxLength()));
        switch (modelField.getValidationType()) {
            case EMAIL: {
                mappingContext.constraint((ConstraintDef)new EmailDef());
                break;
            }
            case CUSTOM: {
                mappingContext.constraint((ConstraintDef)new PatternDef().regexp(modelField.getCustomValidationRegex()));
                break;
            }
            case URL: {
                mappingContext.constraint((ConstraintDef)new URLDef());
                break;
            }
        }
    }

    private void addConstraints(ConstraintMapping constraintMapping, LongTextModelField modelField, LongTextFragmentField fragmentField) {
        PropertyConstraintMappingContext propertyConstraintMappingContext = this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
        ContainerElementConstraintMappingContext mappingContext = propertyConstraintMappingContext.containerElementType(0, new int[0]);
        if (modelField.getMimeType().equals((Object)MimeType.HTML)) {
            mappingContext.constraint((ConstraintDef)new HtmlDef());
        }
    }

    private void addConstraints(ConstraintMapping constraintMapping, LongNumberModelField modelField, LongNumberFragmentField fragmentField) {
        PropertyConstraintMappingContext propertyConstraintMappingContext = this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
        ContainerElementConstraintMappingContext mappingContext = propertyConstraintMappingContext.containerElementType(0, new int[0]);
        if (modelField.getMin() != null) {
            mappingContext.constraint((ConstraintDef)new MinDef().value(modelField.getMin().longValue()));
        }
        if (modelField.getMax() != null) {
            mappingContext.constraint((ConstraintDef)new MaxDef().value(modelField.getMax().longValue()));
        }
    }

    private void addConstraints(ConstraintMapping constraintMapping, DoubleNumberModelField modelField, DoubleNumberFragmentField fragmentField) {
        PropertyConstraintMappingContext propertyConstraintMappingContext = this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
        ContainerElementConstraintMappingContext mappingContext = propertyConstraintMappingContext.containerElementType(0, new int[0]);
        if (modelField.getMin() != null) {
            mappingContext.constraint((ConstraintDef)new DecimalMinDef().value(modelField.getMin().toString()));
        }
        if (modelField.getMax() != null) {
            mappingContext.constraint((ConstraintDef)new DecimalMaxDef().value(modelField.getMax().toString()));
        }
    }

    private void addConstraints(ConstraintMapping constraintMapping, EnumerationModelField modelField, EnumerationFragmentField fragmentField) {
        PropertyConstraintMappingContext propertyConstraintMappingContext = this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
        ContainerElementConstraintMappingContext mappingContext = propertyConstraintMappingContext.containerElementType(0, new int[0]);
        mappingContext.constraint((ConstraintDef)new AllowedValuesDef().allowedValues(modelField.getValues().stream().map(EnumerationModelFieldAllOfValues::getValue).collect(Collectors.toSet())));
    }

    private void addConstraints(ConstraintMapping constraintMapping, BooleanModelField modelField, BooleanFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, DateModelField modelField, DateFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, TimeModelField modelField, TimeFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, DateTimeModelField modelField, DateTimeFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, JsonModelField modelField, JsonFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, ContentReferenceModelField modelField, ContentReferenceFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, FragmentReferenceModelField modelField, FragmentReferenceFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }

    private void addConstraints(ConstraintMapping constraintMapping, TagModelField modelField, TagFragmentField fragmentField) {
        this.buildValuesPropertyConstraintMappingContext(constraintMapping, modelField, fragmentField.getClass());
    }
}

