/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.validators;

import com.adobe.cq.dam.cfm.openapi.models.BooleanFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.BooleanModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.DateFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateModelField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeModelField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DoubleNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.EnumerationFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.JsonFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.LongNumberModelField;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TagFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextModelField;
import com.adobe.cq.dam.cfm.openapi.models.TimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TimeModelField;
import java.util.List;

public class DefaultValueProvider {
    private <T> List<T> getMultipleDefaultValue(T defaultValue) {
        if (defaultValue == null) {
            return List.of();
        }
        return List.of(defaultValue);
    }

    public ContentFragmentField getDefault(ContentFragmentModelField modelField) {
        switch (modelField.getType()) {
            case TEXT: {
                TextModelField textModelField = (TextModelField)modelField;
                return new TextFragmentField().values(this.getMultipleDefaultValue(textModelField.getDefaultValue())).type(DataType.TEXT).multiple(Boolean.TRUE.equals(textModelField.getMultiple())).name(modelField.getName());
            }
            case NUMBER: {
                LongNumberModelField longNumberModelField = (LongNumberModelField)modelField;
                return new LongNumberFragmentField().values(this.getMultipleDefaultValue(longNumberModelField.getDefaultValue())).type(DataType.NUMBER).multiple(Boolean.TRUE.equals(longNumberModelField.getMultiple())).name(modelField.getName());
            }
            case FLOAT_NUMBER: {
                DoubleNumberModelField doubleNumberModelField = (DoubleNumberModelField)modelField;
                return new DoubleNumberFragmentField().values(this.getMultipleDefaultValue(doubleNumberModelField.getDefaultValue())).type(DataType.FLOAT_NUMBER).multiple(Boolean.TRUE.equals(doubleNumberModelField.getMultiple())).name(modelField.getName());
            }
            case BOOLEAN: {
                BooleanModelField booleanModelField = (BooleanModelField)modelField;
                return new BooleanFragmentField().values(this.getMultipleDefaultValue(booleanModelField.getDefaultValue())).type(DataType.BOOLEAN).multiple(Boolean.TRUE.equals(booleanModelField.getMultiple())).name(modelField.getName());
            }
            case DATE: {
                DateModelField dateModelField = (DateModelField)modelField;
                return new DateFragmentField().values(this.getMultipleDefaultValue(dateModelField.getDefaultValue())).type(DataType.DATE).multiple(Boolean.TRUE.equals(dateModelField.getMultiple())).name(modelField.getName());
            }
            case TIME: {
                TimeModelField timeModelField = (TimeModelField)modelField;
                return new TimeFragmentField().values(this.getMultipleDefaultValue(timeModelField.getDefaultValue())).type(DataType.TIME).multiple(Boolean.TRUE.equals(timeModelField.getMultiple())).name(modelField.getName());
            }
            case DATE_TIME: {
                DateTimeModelField dateTimeModelField = (DateTimeModelField)modelField;
                return new DateTimeFragmentField().values(this.getMultipleDefaultValue(dateTimeModelField.getDefaultValue())).type(DataType.DATE_TIME).multiple(Boolean.TRUE.equals(dateTimeModelField.getMultiple())).name(modelField.getName());
            }
            case LONG_TEXT: {
                return new LongTextFragmentField().type(DataType.LONG_TEXT).multiple(Boolean.TRUE.equals(modelField.getMultiple())).name(modelField.getName());
            }
            case ENUMERATION: {
                return new EnumerationFragmentField().type(DataType.ENUMERATION).multiple(true).name(modelField.getName());
            }
            case CONTENT_REFERENCE: {
                return new ContentReferenceFragmentField().type(DataType.CONTENT_REFERENCE).multiple(Boolean.TRUE.equals(modelField.getMultiple())).name(modelField.getName());
            }
            case CONTENT_FRAGMENT: {
                return new FragmentReferenceFragmentField().type(DataType.CONTENT_FRAGMENT).multiple(Boolean.TRUE.equals(modelField.getMultiple())).name(modelField.getName());
            }
            case TAG: {
                return new TagFragmentField().type(DataType.TAG).multiple(Boolean.TRUE.equals(modelField.getMultiple())).name(modelField.getName());
            }
            case JSON: {
                return new JsonFragmentField().type(DataType.JSON).name(modelField.getName());
            }
        }
        throw new IllegalArgumentException("Unknown model field type: " + modelField.getType());
    }
}

