/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors.tagging;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.TagList;
import com.adobe.cq.dam.cfm.tags.AbstractTagsProcessor;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-14079)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class UpdateTagsCFMProcessor
extends AbstractTagsProcessor {
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to update tags of Content Fragment Model.";
    }

    @Override
    protected boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException, ContentFragmentException, ETagException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = THIS_MODEL_PROCESSOR_URL_PATTERN_TAGS.matcher(request.getPathInfo());
        if (!request.isPut() || !matcher.matches()) {
            return false;
        }
        TagManager tagManager = (TagManager)request.getResourceResolver().adaptTo(TagManager.class);
        if (tagManager == null) {
            LOG.error("Unable to get TagManager from ResourceResolver.");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"The TagManager cannot be accessed by the current session."));
            return true;
        }
        String modelId = matcher.group(1);
        Resource modelResource = this.contentFragmentModelManager.getContentFragmentResource(request.getResourceResolver(), modelId);
        if (modelResource == null) {
            LOG.error("Resource with id '{}' does not exist.", (Object)modelId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment model with id '%s' does not exist.", modelId)), request.isPut());
            return true;
        }
        ContentFragmentModel model = this.contentFragmentModelManager.getModel(request.getResourceResolver(), modelId);
        if (model == null) {
            LOG.error("The content fragment model with id '{}' does not exist.", (Object)modelId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment model with id '%s' does not exist.", modelId)), request.isPut());
            return true;
        }
        if (this.isNotModifiable(modelResource)) {
            LOG.error("User is not allowed to modify tags on this fragment.");
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"User is not allowed to modify tags on this fragment."));
            return true;
        }
        String currentEtag = this.jsonDataProcessor.getETagForTags(this.convertTags((Tag[])model.getTags().stream().map(tag -> tagManager.resolve(tag.getId())).filter(Objects::nonNull).distinct().toArray(Tag[]::new)));
        if (!this.eTagService.strongComparison(currentEtag, request.getHeader("If-Match"))) {
            LOG.error("The latest ETag of Model Tag is \"{}\".", (Object)currentEtag);
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The latest ETag of Model Tag is \"%s\".", currentEtag)));
            return true;
        }
        Set<Tag> payloadTags = this.getTagsFromPayloadOrEndResponse(request, response, tagManager);
        if (payloadTags == null) {
            return true;
        }
        model = this.contentFragmentModelManager.setModelTags(request.getResourceResolver(), model, payloadTags.toArray(new Tag[0]));
        Tag[] modelTags = (Tag[])model.getTags().stream().map(tag -> tagManager.resolve(tag.getId())).filter(Objects::nonNull).distinct().toArray(Tag[]::new);
        TagList currentModelTags = this.convertTags(modelTags);
        String etag = this.jsonDataProcessor.getETagForTags(currentModelTags);
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        this.eTagService.setETagHeader(response, etag);
        response.setStatus(200);
        this.jsonDataProcessor.writeValue(response.getWriter(), currentModelTags);
        return true;
    }
}

