/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors.tagging;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.TagList;
import com.adobe.cq.dam.cfm.tags.AbstractTagsProcessor;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.http.entity.ContentType;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-8257)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ReadTagsCFMProcessor
extends AbstractTagsProcessor {
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to retrieve tags from Content Fragment Model";
    }

    @Override
    protected boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = THIS_MODEL_PROCESSOR_URL_PATTERN_TAGS.matcher(request.getPathInfo());
        if (!request.isGet() || !matcher.matches()) {
            return false;
        }
        TagManager tagManager = (TagManager)request.getResourceResolver().adaptTo(TagManager.class);
        if (tagManager == null) {
            LOG.error("Unable to get TagManager from ResourceResolver.");
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"The TagManager cannot be accessed by the current session."));
            return true;
        }
        String modelId = matcher.group(1);
        Resource modelResource = this.contentFragmentModelManager.getContentFragmentResource(request.getResourceResolver(), modelId);
        if (modelResource == null) {
            LOG.error("Resource with id '{}' does not exist.", (Object)modelId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment model with id '%s' does not exist.", modelId)), request.isGet());
            return true;
        }
        ContentFragmentModel model = this.contentFragmentModelManager.getModel(request.getResourceResolver(), modelId);
        if (model == null) {
            LOG.error("The content fragment model with id '{}' does not exist.", (Object)modelId);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment model with id '%s' does not exist.", modelId)), request.isGet());
            return true;
        }
        TagList tagList = this.convertTags((Tag[])model.getTags().stream().map(tag -> tagManager.resolve(tag.getId())).filter(Objects::nonNull).toArray(Tag[]::new));
        String etag = this.jsonDataProcessor.getETagForTags(tagList);
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        this.eTagService.setETagHeader(response, etag);
        response.setStatus(200);
        this.jsonDataProcessor.writeValue(response.getWriter(), tagList);
        return true;
    }
}

