/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.services.LastModifiedService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.impl.Constants;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.servlets.processors.AbstractCFMProcessor;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import java.io.IOException;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"})
public class ReadCFMProcessor
extends AbstractCFMProcessor {
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;
    @Reference
    private ETagService eTagService;
    @Reference
    private LastModifiedService lastModifiedService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to retrieve the Content Fragment Model";
    }

    @Override
    public boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = Constants.CFM_ID_REQUEST_PATTERN.matcher(request.getPathInfo());
        if (matcher.matches() && (request.isGet() || request.isHead())) {
            String id = matcher.group(1);
            ContentFragmentModel model = this.contentFragmentModelManager.getModel(request.getResourceResolver(), id);
            if (model != null) {
                boolean cacheIsValid = this.eTagService.isClientCacheValid(request, response, this.jsonDataProcessor.getETag(model));
                boolean bl = cacheIsValid = this.lastModifiedService.isClientCacheValid(request, response, model.getModified().getAt().toInstant().toEpochMilli()) || cacheIsValid;
                if (cacheIsValid) {
                    return true;
                }
                response.setContentType("application/json");
                if (request.isGet()) {
                    this.jsonDataProcessor.writeValue(response.getWriter(), model);
                }
            } else {
                response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The content fragment model with id %s does not exist.", id)), request.isGet());
            }
            return true;
        }
        return false;
    }
}

