/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.pagination.Cursor;
import com.adobe.aem.openapi.pagination.PaginatedItems;
import com.adobe.aem.openapi.pagination.PaginationRequestInfo;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.servlets.processors.AbstractCFMProcessor;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"})
public class ListCFMProcessor
extends AbstractCFMProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ListCFMProcessor.class);
    static final String CONF_FOLDER = "/conf";
    static final String REQUEST_PARAM_CURSOR = "cursor";
    static final String REQUEST_PARAM_LIMIT = "limit";
    static final int DEFAULT_QUERY_LIMIT = 50;
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    @Override
    public boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.isGet() && request.getPathInfo() == null && "/sites/cf/models".equals(request.getServletPath())) {
            PaginationRequestInfo paginationRequestInfo = new PaginationRequestInfo(request, 50);
            int limit = paginationRequestInfo.getLimit();
            if (limit == -1) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid value for the 'limit' request parameter."), request.isGet());
            }
            if (StringUtils.isWhitespace((CharSequence)paginationRequestInfo.getCursor())) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid 'cursor' request parameter."));
            }
            response.setContentType("application/json");
            this.jsonDataProcessor.writeValue(response.getWriter(), this.getModels(request.getResourceResolver(), paginationRequestInfo));
            return true;
        }
        return false;
    }

    @Override
    protected String getGenericErrorMessage() {
        return "Error while listing content fragment models";
    }

    private PaginatedItems<ContentFragmentModel> getModels(@NotNull ResourceResolver resourceResolver, @NotNull PaginationRequestInfo paginationRequestInfo) {
        String after = null;
        if (paginationRequestInfo.getCursor() != null) {
            String pathFromCursor = Cursor.decode((String)paginationRequestInfo.getCursor());
            if (pathFromCursor == null) {
                LOG.error("Unable to decode request provided cursor {}.", (Object)paginationRequestInfo.getCursor());
                return new PaginatedItems(Stream.empty(), contentFragmentModel -> new Cursor(contentFragmentModel.getPath()), paginationRequestInfo, true);
            }
            after = pathFromCursor;
        }
        return new PaginatedItems(this.contentFragmentModelManager.getModels(resourceResolver, paginationRequestInfo.getLimit() + 1, after).stream(), contentFragmentModel -> new Cursor(contentFragmentModel.getPath()), paginationRequestInfo, true);
    }
}

