/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.Metrics;
import com.adobe.cq.dam.cfm.impl.Constants;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.persistence.PersistableContentFragmentModel;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.Converter;
import com.adobe.cq.dam.cfm.impl.servlets.processors.AbstractCFMProcessor;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"})
public class EditCFMProcessor
extends AbstractCFMProcessor {
    private static final Logger log = LoggerFactory.getLogger(EditCFMProcessor.class);
    private static final String METRIC_LIST = "models";
    private static final String METRIC_NAME = "validate";
    @Reference
    private ETagService eTagService;
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;
    @Reference
    Converter converter;
    @Reference
    RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private Metrics metrics;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to process content fragment model patch";
    }

    @Override
    protected boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException {
        ContentFragmentModel updatedModel;
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = Constants.CFM_ID_REQUEST_PATTERN.matcher(request.getPathInfo());
        if (!matcher.matches() || !request.isPatch()) {
            return false;
        }
        String id = matcher.group(1);
        String contentType = request.getContentType();
        if (contentType == null || !contentType.startsWith("application/json-patch+json")) {
            String message = String.format("This endpoint only accepts %s payloads.", "application/json-patch+json");
            log.info(message);
            response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)message));
            return true;
        }
        Resource resource = this.contentFragmentModelManager.getContentFragmentResource(request.getResourceResolver(), id);
        if (resource == null) {
            String message = String.format("The content fragment model with id %s does not exist.", id);
            log.info(message);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)message));
            return true;
        }
        FragmentTemplate fragmentTemplate = (FragmentTemplate)resource.adaptTo(FragmentTemplate.class);
        if (fragmentTemplate == null) {
            String message = String.format("The content fragment model with id %s is invalid.", id);
            log.info(message);
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)message));
            return true;
        }
        ContentFragmentModel model = this.converter.convert(fragmentTemplate);
        String eTag = this.jsonDataProcessor.getETag(model);
        if (!this.eTagService.isConditionFulfilled(request, response, eTag)) {
            String message = String.format("The current eTag \"%s\" of the fragment with id %s does not match the If-Match header.", eTag, id);
            log.info(message);
            response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)message));
            return true;
        }
        JsonPatch patch = this.getPatch(request, response);
        if (patch == null) {
            return true;
        }
        JsonObject modelJson = this.getModelAsJson(request, response, model);
        JsonObject patchedModelJson = this.applyPatch(request, response, modelJson, patch);
        if (patchedModelJson == null) {
            return true;
        }
        if (modelJson.equals(patchedModelJson)) {
            updatedModel = model;
        } else {
            ContentFragmentModel patchedModel = this.jsonDataProcessor.readValue(patchedModelJson.toString(), ContentFragmentModel.class);
            Optional<String> optionalValidationMessage = this.requestValidator.validateModelFields(patchedModel.getFields());
            if (optionalValidationMessage.isPresent()) {
                log.info(this.getGenericErrorMessage(), (Object)optionalValidationMessage.get());
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)optionalValidationMessage.get()));
                return true;
            }
            long start = System.currentTimeMillis();
            List<String> validationMessages = this.requestValidator.getValidationMessages(patchedModel);
            this.metrics.addMetricTimer(METRIC_LIST, METRIC_NAME, start);
            if (!validationMessages.isEmpty()) {
                log.info(this.getGenericErrorMessage(), (Object)this.requestValidator.buildValidationMessage(validationMessages));
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)this.requestValidator.buildValidationMessage(validationMessages)));
                return true;
            }
            updatedModel = this.contentFragmentModelManager.updateModel(new PersistableContentFragmentModel().withBackingResource(resource).withBase(model).withChanges(patchedModel));
        }
        response.setContentType("application/json");
        this.eTagService.setETagHeader(response, this.jsonDataProcessor.getETag(updatedModel));
        this.jsonDataProcessor.writeValue(response.getWriter(), updatedModel);
        return true;
    }

    @Nullable
    private JsonObject applyPatch(@NotNull Request request, @NotNull Response response, @NotNull JsonObject model, @NotNull JsonPatch patch) throws IOException {
        try {
            return (JsonObject)patch.apply((JsonStructure)model);
        }
        catch (Exception e) {
            log.error("Unable to apply patch.", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Unable to apply patch."));
            return null;
        }
    }

    @NotNull
    private JsonObject getModelAsJson(@NotNull Request request, @NotNull Response response, @NotNull ContentFragmentModel model) throws IOException {
        StringWriter writer = new StringWriter();
        this.jsonDataProcessor.writeValue(writer, model);
        try (JsonReader parser = Json.createReader((Reader)new StringReader(writer.toString()));){
            JsonObject jsonObject = parser.readObject();
            return jsonObject;
        }
    }

    @Nullable
    private JsonPatch getPatch(@NotNull Request request, @NotNull Response response) throws IOException {
        JsonPatch patch = null;
        try (JsonReader reader = Json.createReader((InputStream)request.getInputStream());){
            JsonStructure structure = reader.read();
            if (structure.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new JsonException("expected an operations array");
            }
            patch = Json.createPatch((JsonArray)structure.asJsonArray());
        }
        catch (NullPointerException | JsonException e) {
            log.error("Invalid JSON patch.", e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)("Invalid JSON patch - " + e.getMessage() + ".")));
        }
        catch (Exception e) {
            log.error("Invalid JSON patch.", (Throwable)e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)"Invalid JSON patch."));
        }
        return patch;
    }
}

