/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.services.ETagService;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.impl.Constants;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.servlets.processors.AbstractCFMProcessor;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import java.io.IOException;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"})
public class DeleteCFMProcessor
extends AbstractCFMProcessor {
    @Reference
    private ContentFragmentModelManager contentFragmentModelManager;
    @Reference
    private ETagService eTagService;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to delete the Content Fragment Model";
    }

    @Override
    public boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws IOException {
        if (request.getPathInfo() == null) {
            return false;
        }
        Matcher matcher = Constants.CFM_ID_REQUEST_PATTERN.matcher(request.getPathInfo());
        if (!matcher.matches() || !request.isDelete()) {
            return false;
        }
        String id = matcher.group(1);
        String ifMatch = request.getHeader("If-Match");
        if (StringUtils.isEmpty((CharSequence)ifMatch)) {
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The %s conditional request header is mandatory.", "If-Match")));
            return true;
        }
        ContentFragmentModel contentFragmentModel = this.contentFragmentModelManager.getModel(request.getResourceResolver(), id);
        if (contentFragmentModel != null) {
            String currentETag = this.jsonDataProcessor.getETag(contentFragmentModel);
            if (!this.eTagService.strongComparison(ifMatch, currentETag)) {
                response.endWithProblem(ProblemDetails.preconditionFailed((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The latest ETag of Content Fragment Model %s is %s.", contentFragmentModel.getId(), currentETag)));
                return true;
            }
            this.contentFragmentModelManager.deleteModel(request.getResourceResolver(), contentFragmentModel);
            request.getResourceResolver().commit();
            response.setStatus(204);
        } else {
            response.endWithProblem(ProblemDetails.notFound((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The Content Fragment Model with id %s does not exist.", id)));
        }
        return true;
    }
}

