/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.Metrics;
import com.adobe.cq.dam.cfm.impl.persistence.ContentFragmentModelManager;
import com.adobe.cq.dam.cfm.impl.servlets.processors.AbstractCFMProcessor;
import com.adobe.cq.dam.cfm.impl.servlets.validators.RequestValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelIdentifier;
import com.adobe.cq.dam.cfm.openapi.models.CreateContentFragmentModels;
import com.day.cq.wcm.api.WCMException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestProcessor.class}, property={"request.processor.api=com.adobe.cq.dam.cfm.impl.servlets.ContentFragmentsModelsAPIServlet"})
public class CreateCFMProcessor
extends AbstractCFMProcessor {
    private static final Logger log = LoggerFactory.getLogger(CreateCFMProcessor.class);
    private static final String METRIC_LIST = "models";
    private static final String METRIC_NAME = "validate";
    @Reference
    private ContentFragmentModelManager modelManager;
    @Reference
    private RequestValidator requestValidator;
    @Reference
    private JsonDataProcessor jsonDataProcessor;
    @Reference
    private Metrics metrics;

    @Override
    protected String getGenericErrorMessage() {
        return "Unable to create a Content Fragment Model";
    }

    @Override
    protected boolean processWithExceptions(@NotNull Request request, @NotNull Response response) throws WCMException, IOException {
        if (!request.isPost() || request.getPathInfo() != null || !"/sites/cf/models".equals(request.getServletPath())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null || !contentType.startsWith("application/json")) {
            response.endWithProblem(ProblemDetails.unsupportedMediaType((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("The request's %s header should be %s.", "Content-Type", "application/json")));
            return true;
        }
        CreateContentFragmentModels requestCreateContentFragmentModels = this.jsonDataProcessor.readValue((InputStream)request.getInputStream(), CreateContentFragmentModels.class);
        List<ContentFragmentModelField> modelFields = requestCreateContentFragmentModels.getModels().stream().flatMap(model -> model.getFields().stream()).collect(Collectors.toUnmodifiableList());
        Optional<String> optionalValidationMessage = this.requestValidator.validateModelFields(modelFields);
        if (optionalValidationMessage.isPresent()) {
            throw new IllegalArgumentException(optionalValidationMessage.get());
        }
        long start = System.currentTimeMillis();
        List<String> validationMessages = this.requestValidator.getValidationMessages(requestCreateContentFragmentModels);
        this.metrics.addMetricTimer(METRIC_LIST, METRIC_NAME, start);
        if (!validationMessages.isEmpty()) {
            throw new IllegalArgumentException(this.requestValidator.buildValidationMessage(validationMessages));
        }
        List<ContentFragmentModel> models = this.modelManager.createModels(request.getResourceResolver(), requestCreateContentFragmentModels.getModels(), true);
        response.setStatus(201);
        response.setContentType("application/json");
        List createdModelsFormatted = models.stream().map(contentFragmentModel -> new ContentFragmentModelIdentifier().id(contentFragmentModel.getId()).path(contentFragmentModel.getPath()).name(contentFragmentModel.getName()).title(contentFragmentModel.getName()).description(contentFragmentModel.getDescription())).collect(Collectors.toList());
        this.jsonDataProcessor.writeValue(response.getWriter(), Map.of("items", createdModelsFormatted));
        return true;
    }
}

