/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.processors;

import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import com.adobe.aem.openapi.servlets.RequestProcessor;
import com.adobe.aem.openapi.servlets.Response;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ETagException;
import com.adobe.cq.dam.cfm.impl.exceptions.ContentFragmentModelResponseException;
import com.adobe.cq.dam.cfm.impl.exceptions.ObjectIntegrityException;
import com.adobe.cq.dam.cfm.impl.exceptions.UnauthorizedActionException;
import com.day.cq.wcm.api.WCMException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Optional;
import org.apache.sling.api.resource.PersistenceException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCFMProcessor
implements RequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractCFMProcessor.class);

    protected abstract boolean processWithExceptions(@NotNull Request var1, @NotNull Response var2) throws WCMException, IOException;

    protected abstract String getGenericErrorMessage();

    public boolean process(@NotNull Request request, @NotNull Response response) throws IOException {
        try {
            return this.processWithExceptions(request, response);
        }
        catch (UnauthorizedActionException e) {
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)(e.getMessage() + ".")));
        }
        catch (ContentFragmentModelResponseException e) {
            response.endWithProblem(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)(this.getGenericErrorMessage() + e.getMessage())));
        }
        catch (WCMException | PersistenceException e) {
            log.error(this.getGenericErrorMessage(), e);
            response.endWithProblem(ProblemDetails.forbidden((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)(this.getGenericErrorMessage() + " - user not allowed.")));
        }
        catch (ETagException | JsonProcessingException | IllegalArgumentException e) {
            log.error(this.getGenericErrorMessage(), e);
            response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)(this.getGenericErrorMessage() + " - " + e.getMessage())));
        }
        catch (Exception e) {
            log.error(this.getGenericErrorMessage(), (Throwable)e);
            response.endWithProblem(this.getProblemDetails(request, e).orElse(ProblemDetails.internalServerError((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)(this.getGenericErrorMessage() + "."))));
        }
        return true;
    }

    private Optional<ProblemDetails> getProblemDetails(@NotNull Request request, @NotNull Exception e) {
        ProblemDetails.MediaType mediaType = ProblemDetails.getBestMediaType((Request)request);
        if (e instanceof ObjectIntegrityException) {
            ObjectIntegrityException objectIntegrityException = (ObjectIntegrityException)e;
            ObjectIntegrityException.Reason reason = objectIntegrityException.getReason();
            if (reason == ObjectIntegrityException.Reason.EXTERNAL) {
                return Optional.of(ProblemDetails.badRequest((ProblemDetails.MediaType)mediaType, (String)e.getMessage()));
            }
            if (reason == ObjectIntegrityException.Reason.INTERNAL) {
                return Optional.of(ProblemDetails.internalServerError((ProblemDetails.MediaType)mediaType, (String)e.getMessage()));
            }
        }
        return Optional.empty();
    }
}

