/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.filters;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;

@Component(service={Filter.class})
@HttpWhiteboardFilterPattern(value={"/sites/cf/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=com.adobe.aem.adobeapi)")
public class XRequestIDFilter
implements Filter {
    public static final String ACTIVE_PATHS = "/sites/cf/*";

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hRequest = (HttpServletRequest)request;
            HttpServletResponse hResponse = (HttpServletResponse)response;
            String xRequestId = hRequest.getHeader("X-Request-Id");
            if (StringUtils.isEmpty((CharSequence)xRequestId)) {
                xRequestId = UUID.randomUUID().toString();
            }
            hResponse.setHeader("X-Request-Id", xRequestId);
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            try {
                currentThread.setName(String.format("[%s] %s", xRequestId, oldName));
                request.setAttribute("X-Request-Id", (Object)xRequestId);
                chain.doFilter(request, response);
            }
            finally {
                currentThread.setName(oldName);
                request.removeAttribute("X-Request-Id");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

