/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.servlets.filters;

import com.adobe.aem.openapi.servlets.DefaultRequest;
import com.adobe.aem.openapi.servlets.DefaultResponse;
import com.adobe.aem.openapi.servlets.ProblemDetails;
import com.adobe.aem.openapi.servlets.Request;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;

@Component(service={Filter.class})
@HttpWhiteboardFilterPattern(value={"/sites/cf/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=com.adobe.aem.adobeapi)")
public class XAdobeAcceptUnsupportedAPI
implements Filter {
    public static final String ACTIVE_PATHS = "/sites/cf/*";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            DefaultRequest request = new DefaultRequest((HttpServletRequest)servletRequest);
            DefaultResponse response = new DefaultResponse((HttpServletResponse)servletResponse);
            String xAdobeAcceptUnsupportedAPI = request.getHeader("X-Adobe-Accept-Unsupported-API");
            if (!"1".equals(xAdobeAcceptUnsupportedAPI)) {
                response.endWithProblem(ProblemDetails.badRequest((ProblemDetails.MediaType)ProblemDetails.getBestMediaType((Request)request), (String)String.format("This endpoint requires clients to send the '%s: 1' request header.", "X-Adobe-Accept-Unsupported-API")), !request.isHead() && !request.isDelete());
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

