/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.impl.persistence.legacy.resource;

import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelItemsResource
extends ResourceWrapper {
    private final Map<String, Resource> fieldToResourceMap;
    private final ResourceResolver resourceResolver = new CacheAwareResourceResolver();

    public ModelItemsResource(@NotNull Resource resource) {
        super(resource);
        HashMap<String, Resource> fieldMap = new HashMap<String, Resource>();
        for (Resource field : this.getResource().getChildren()) {
            ValueMap fieldProperties = field.getValueMap();
            String fieldName = (String)fieldProperties.get("name", String.class);
            if (!StringUtils.isNotEmpty((CharSequence)fieldName)) continue;
            fieldMap.put(fieldName, field);
        }
        this.fieldToResourceMap = new HashMap<String, Resource>(fieldMap);
    }

    @Nullable
    public Resource getResource(@NotNull ContentFragmentModelField field) {
        return this.fieldToResourceMap.get(field.getName());
    }

    public void deleteField(@NotNull String fieldName) throws PersistenceException {
        Resource toDelete = this.fieldToResourceMap.remove(fieldName);
        if (toDelete != null) {
            this.getResourceResolver().delete(toDelete);
        }
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    private class CacheAwareResourceResolver
    extends ResourceResolverWrapper {
        public CacheAwareResourceResolver() {
            super(ModelItemsResource.this.getResource().getResourceResolver());
        }

        @NotNull
        public Resource create(@NotNull Resource parent, @NotNull String name, Map<String, Object> properties) throws PersistenceException {
            Resource newResource = super.create(parent, name, properties);
            ModelItemsResource.this.fieldToResourceMap.put(name, newResource);
            return newResource;
        }
    }
}

